/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStage;
import software.amazon.awssdk.services.elasticsearch.model.ChangeProgressStageListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ConfigChangeStatus;
import software.amazon.awssdk.services.elasticsearch.model.InitiatedBy;
import software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus;
import software.amazon.awssdk.services.elasticsearch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeProgressStatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeProgressStatusDetails> {
    private static final SdkField<String> CHANGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeId").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::changeId)).setter(ChangeProgressStatusDetails.setter(Builder::changeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::startTime)).setter(ChangeProgressStatusDetails.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::statusAsString)).setter(ChangeProgressStatusDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> PENDING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingProperties").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::pendingProperties)).setter(ChangeProgressStatusDetails.setter(Builder::pendingProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMPLETED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompletedProperties").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::completedProperties)).setter(ChangeProgressStatusDetails.setter(Builder::completedProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_NUMBER_OF_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalNumberOfStages").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::totalNumberOfStages)).setter(ChangeProgressStatusDetails.setter(Builder::totalNumberOfStages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfStages").build()}).build();
    private static final SdkField<List<ChangeProgressStage>> CHANGE_PROGRESS_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangeProgressStages").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::changeProgressStages)).setter(ChangeProgressStatusDetails.setter(Builder::changeProgressStages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressStages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeProgressStage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONFIG_CHANGE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigChangeStatus").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::configChangeStatusAsString)).setter(ChangeProgressStatusDetails.setter(Builder::configChangeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigChangeStatus").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::lastUpdatedTime)).setter(ChangeProgressStatusDetails.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiatedBy").getter(ChangeProgressStatusDetails.getter(ChangeProgressStatusDetails::initiatedByAsString)).setter(ChangeProgressStatusDetails.setter(Builder::initiatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_ID_FIELD, START_TIME_FIELD, STATUS_FIELD, PENDING_PROPERTIES_FIELD, COMPLETED_PROPERTIES_FIELD, TOTAL_NUMBER_OF_STAGES_FIELD, CHANGE_PROGRESS_STAGES_FIELD, CONFIG_CHANGE_STATUS_FIELD, LAST_UPDATED_TIME_FIELD, INITIATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ChangeProgressStatusDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String changeId;
    private final Instant startTime;
    private final String status;
    private final List<String> pendingProperties;
    private final List<String> completedProperties;
    private final Integer totalNumberOfStages;
    private final List<ChangeProgressStage> changeProgressStages;
    private final String configChangeStatus;
    private final Instant lastUpdatedTime;
    private final String initiatedBy;

    private ChangeProgressStatusDetails(BuilderImpl builder) {
        this.changeId = builder.changeId;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.pendingProperties = builder.pendingProperties;
        this.completedProperties = builder.completedProperties;
        this.totalNumberOfStages = builder.totalNumberOfStages;
        this.changeProgressStages = builder.changeProgressStages;
        this.configChangeStatus = builder.configChangeStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.initiatedBy = builder.initiatedBy;
    }

    public final String changeId() {
        return this.changeId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final OverallChangeStatus status() {
        return OverallChangeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasPendingProperties() {
        return this.pendingProperties != null && !(this.pendingProperties instanceof SdkAutoConstructList);
    }

    public final List<String> pendingProperties() {
        return this.pendingProperties;
    }

    public final boolean hasCompletedProperties() {
        return this.completedProperties != null && !(this.completedProperties instanceof SdkAutoConstructList);
    }

    public final List<String> completedProperties() {
        return this.completedProperties;
    }

    public final Integer totalNumberOfStages() {
        return this.totalNumberOfStages;
    }

    public final boolean hasChangeProgressStages() {
        return this.changeProgressStages != null && !(this.changeProgressStages instanceof SdkAutoConstructList);
    }

    public final List<ChangeProgressStage> changeProgressStages() {
        return this.changeProgressStages;
    }

    public final ConfigChangeStatus configChangeStatus() {
        return ConfigChangeStatus.fromValue(this.configChangeStatus);
    }

    public final String configChangeStatusAsString() {
        return this.configChangeStatus;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final InitiatedBy initiatedBy() {
        return InitiatedBy.fromValue(this.initiatedBy);
    }

    public final String initiatedByAsString() {
        return this.initiatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.changeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingProperties() ? this.pendingProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompletedProperties() ? this.completedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfStages());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeProgressStages() ? this.changeProgressStages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configChangeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedByAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeProgressStatusDetails)) {
            return false;
        }
        ChangeProgressStatusDetails other = (ChangeProgressStatusDetails)obj;
        return Objects.equals(this.changeId(), other.changeId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasPendingProperties() == other.hasPendingProperties() && Objects.equals(this.pendingProperties(), other.pendingProperties()) && this.hasCompletedProperties() == other.hasCompletedProperties() && Objects.equals(this.completedProperties(), other.completedProperties()) && Objects.equals(this.totalNumberOfStages(), other.totalNumberOfStages()) && this.hasChangeProgressStages() == other.hasChangeProgressStages() && Objects.equals(this.changeProgressStages(), other.changeProgressStages()) && Objects.equals(this.configChangeStatusAsString(), other.configChangeStatusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.initiatedByAsString(), other.initiatedByAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeProgressStatusDetails").add("ChangeId", (Object)this.changeId()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("PendingProperties", this.hasPendingProperties() ? this.pendingProperties() : null).add("CompletedProperties", this.hasCompletedProperties() ? this.completedProperties() : null).add("TotalNumberOfStages", (Object)this.totalNumberOfStages()).add("ChangeProgressStages", this.hasChangeProgressStages() ? this.changeProgressStages() : null).add("ConfigChangeStatus", (Object)this.configChangeStatusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("InitiatedBy", (Object)this.initiatedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeId": {
                return Optional.ofNullable(clazz.cast(this.changeId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "PendingProperties": {
                return Optional.ofNullable(clazz.cast(this.pendingProperties()));
            }
            case "CompletedProperties": {
                return Optional.ofNullable(clazz.cast(this.completedProperties()));
            }
            case "TotalNumberOfStages": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfStages()));
            }
            case "ChangeProgressStages": {
                return Optional.ofNullable(clazz.cast(this.changeProgressStages()));
            }
            case "ConfigChangeStatus": {
                return Optional.ofNullable(clazz.cast(this.configChangeStatusAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "InitiatedBy": {
                return Optional.ofNullable(clazz.cast(this.initiatedByAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChangeId", CHANGE_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PendingProperties", PENDING_PROPERTIES_FIELD);
        map.put("CompletedProperties", COMPLETED_PROPERTIES_FIELD);
        map.put("TotalNumberOfStages", TOTAL_NUMBER_OF_STAGES_FIELD);
        map.put("ChangeProgressStages", CHANGE_PROGRESS_STAGES_FIELD);
        map.put("ConfigChangeStatus", CONFIG_CHANGE_STATUS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("InitiatedBy", INITIATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeProgressStatusDetails, T> g) {
        return obj -> g.apply((ChangeProgressStatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String changeId;
        private Instant startTime;
        private String status;
        private List<String> pendingProperties = DefaultSdkAutoConstructList.getInstance();
        private List<String> completedProperties = DefaultSdkAutoConstructList.getInstance();
        private Integer totalNumberOfStages;
        private List<ChangeProgressStage> changeProgressStages = DefaultSdkAutoConstructList.getInstance();
        private String configChangeStatus;
        private Instant lastUpdatedTime;
        private String initiatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeProgressStatusDetails model) {
            this.changeId(model.changeId);
            this.startTime(model.startTime);
            this.status(model.status);
            this.pendingProperties(model.pendingProperties);
            this.completedProperties(model.completedProperties);
            this.totalNumberOfStages(model.totalNumberOfStages);
            this.changeProgressStages(model.changeProgressStages);
            this.configChangeStatus(model.configChangeStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.initiatedBy(model.initiatedBy);
        }

        public final String getChangeId() {
            return this.changeId;
        }

        public final void setChangeId(String changeId) {
            this.changeId = changeId;
        }

        @Override
        public final Builder changeId(String changeId) {
            this.changeId = changeId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OverallChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getPendingProperties() {
            if (this.pendingProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pendingProperties;
        }

        public final void setPendingProperties(Collection<String> pendingProperties) {
            this.pendingProperties = StringListCopier.copy(pendingProperties);
        }

        @Override
        public final Builder pendingProperties(Collection<String> pendingProperties) {
            this.pendingProperties = StringListCopier.copy(pendingProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingProperties(String ... pendingProperties) {
            this.pendingProperties(Arrays.asList(pendingProperties));
            return this;
        }

        public final Collection<String> getCompletedProperties() {
            if (this.completedProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.completedProperties;
        }

        public final void setCompletedProperties(Collection<String> completedProperties) {
            this.completedProperties = StringListCopier.copy(completedProperties);
        }

        @Override
        public final Builder completedProperties(Collection<String> completedProperties) {
            this.completedProperties = StringListCopier.copy(completedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder completedProperties(String ... completedProperties) {
            this.completedProperties(Arrays.asList(completedProperties));
            return this;
        }

        public final Integer getTotalNumberOfStages() {
            return this.totalNumberOfStages;
        }

        public final void setTotalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
        }

        @Override
        public final Builder totalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
            return this;
        }

        public final List<ChangeProgressStage.Builder> getChangeProgressStages() {
            List<ChangeProgressStage.Builder> result = ChangeProgressStageListCopier.copyToBuilder(this.changeProgressStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeProgressStages(Collection<ChangeProgressStage.BuilderImpl> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copyFromBuilder(changeProgressStages);
        }

        @Override
        public final Builder changeProgressStages(Collection<ChangeProgressStage> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copy(changeProgressStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(ChangeProgressStage ... changeProgressStages) {
            this.changeProgressStages(Arrays.asList(changeProgressStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(Consumer<ChangeProgressStage.Builder> ... changeProgressStages) {
            this.changeProgressStages(Stream.of(changeProgressStages).map(c -> (ChangeProgressStage)((ChangeProgressStage.Builder)ChangeProgressStage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getConfigChangeStatus() {
            return this.configChangeStatus;
        }

        public final void setConfigChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
        }

        @Override
        public final Builder configChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
            return this;
        }

        @Override
        public final Builder configChangeStatus(ConfigChangeStatus configChangeStatus) {
            this.configChangeStatus(configChangeStatus == null ? null : configChangeStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getInitiatedBy() {
            return this.initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        @Override
        public final Builder initiatedBy(InitiatedBy initiatedBy) {
            this.initiatedBy(initiatedBy == null ? null : initiatedBy.toString());
            return this;
        }

        public ChangeProgressStatusDetails build() {
            return new ChangeProgressStatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeProgressStatusDetails> {
        public Builder changeId(String var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(OverallChangeStatus var1);

        public Builder pendingProperties(Collection<String> var1);

        public Builder pendingProperties(String ... var1);

        public Builder completedProperties(Collection<String> var1);

        public Builder completedProperties(String ... var1);

        public Builder totalNumberOfStages(Integer var1);

        public Builder changeProgressStages(Collection<ChangeProgressStage> var1);

        public Builder changeProgressStages(ChangeProgressStage ... var1);

        public Builder changeProgressStages(Consumer<ChangeProgressStage.Builder> ... var1);

        public Builder configChangeStatus(String var1);

        public Builder configChangeStatus(ConfigChangeStatus var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder initiatedBy(String var1);

        public Builder initiatedBy(InitiatedBy var1);
    }
}

