/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizedPrincipal;
import software.amazon.awssdk.services.elasticsearch.model.AuthorizedPrincipalListCopier;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVpcEndpointAccessResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, ListVpcEndpointAccessResponse> {
    private static final SdkField<List<AuthorizedPrincipal>> AUTHORIZED_PRINCIPAL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedPrincipalList").getter(ListVpcEndpointAccessResponse.getter(ListVpcEndpointAccessResponse::authorizedPrincipalList)).setter(ListVpcEndpointAccessResponse.setter(Builder::authorizedPrincipalList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedPrincipalList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizedPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListVpcEndpointAccessResponse.getter(ListVpcEndpointAccessResponse::nextToken)).setter(ListVpcEndpointAccessResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_PRINCIPAL_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVpcEndpointAccessResponse.memberNameToFieldInitializer();
    private final List<AuthorizedPrincipal> authorizedPrincipalList;
    private final String nextToken;

    private ListVpcEndpointAccessResponse(BuilderImpl builder) {
        super(builder);
        this.authorizedPrincipalList = builder.authorizedPrincipalList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuthorizedPrincipalList() {
        return this.authorizedPrincipalList != null && !(this.authorizedPrincipalList instanceof SdkAutoConstructList);
    }

    public final List<AuthorizedPrincipal> authorizedPrincipalList() {
        return this.authorizedPrincipalList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedPrincipalList() ? this.authorizedPrincipalList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcEndpointAccessResponse)) {
            return false;
        }
        ListVpcEndpointAccessResponse other = (ListVpcEndpointAccessResponse)((Object)obj);
        return this.hasAuthorizedPrincipalList() == other.hasAuthorizedPrincipalList() && Objects.equals(this.authorizedPrincipalList(), other.authorizedPrincipalList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListVpcEndpointAccessResponse").add("AuthorizedPrincipalList", this.hasAuthorizedPrincipalList() ? this.authorizedPrincipalList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizedPrincipalList": {
                return Optional.ofNullable(clazz.cast(this.authorizedPrincipalList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthorizedPrincipalList", AUTHORIZED_PRINCIPAL_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcEndpointAccessResponse, T> g) {
        return obj -> g.apply((ListVpcEndpointAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<AuthorizedPrincipal> authorizedPrincipalList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcEndpointAccessResponse model) {
            super(model);
            this.authorizedPrincipalList(model.authorizedPrincipalList);
            this.nextToken(model.nextToken);
        }

        public final List<AuthorizedPrincipal.Builder> getAuthorizedPrincipalList() {
            List<AuthorizedPrincipal.Builder> result = AuthorizedPrincipalListCopier.copyToBuilder(this.authorizedPrincipalList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedPrincipalList(Collection<AuthorizedPrincipal.BuilderImpl> authorizedPrincipalList) {
            this.authorizedPrincipalList = AuthorizedPrincipalListCopier.copyFromBuilder(authorizedPrincipalList);
        }

        @Override
        public final Builder authorizedPrincipalList(Collection<AuthorizedPrincipal> authorizedPrincipalList) {
            this.authorizedPrincipalList = AuthorizedPrincipalListCopier.copy(authorizedPrincipalList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedPrincipalList(AuthorizedPrincipal ... authorizedPrincipalList) {
            this.authorizedPrincipalList(Arrays.asList(authorizedPrincipalList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedPrincipalList(Consumer<AuthorizedPrincipal.Builder> ... authorizedPrincipalList) {
            this.authorizedPrincipalList(Stream.of(authorizedPrincipalList).map(c -> (AuthorizedPrincipal)((AuthorizedPrincipal.Builder)AuthorizedPrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListVpcEndpointAccessResponse build() {
            return new ListVpcEndpointAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVpcEndpointAccessResponse> {
        public Builder authorizedPrincipalList(Collection<AuthorizedPrincipal> var1);

        public Builder authorizedPrincipalList(AuthorizedPrincipal ... var1);

        public Builder authorizedPrincipalList(Consumer<AuthorizedPrincipal.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

