/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.PackageDetails;
import software.amazon.awssdk.services.elasticsearch.model.PackageDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePackagesResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribePackagesResponse> {
    private static final SdkField<List<PackageDetails>> PACKAGE_DETAILS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PackageDetailsList").getter(DescribePackagesResponse.getter(DescribePackagesResponse::packageDetailsList)).setter(DescribePackagesResponse.setter(Builder::packageDetailsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDetailsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribePackagesResponse.getter(DescribePackagesResponse::nextToken)).setter(DescribePackagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_DETAILS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribePackagesResponse.memberNameToFieldInitializer();
    private final List<PackageDetails> packageDetailsList;
    private final String nextToken;

    private DescribePackagesResponse(BuilderImpl builder) {
        super(builder);
        this.packageDetailsList = builder.packageDetailsList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPackageDetailsList() {
        return this.packageDetailsList != null && !(this.packageDetailsList instanceof SdkAutoConstructList);
    }

    public final List<PackageDetails> packageDetailsList() {
        return this.packageDetailsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageDetailsList() ? this.packageDetailsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePackagesResponse)) {
            return false;
        }
        DescribePackagesResponse other = (DescribePackagesResponse)((Object)obj);
        return this.hasPackageDetailsList() == other.hasPackageDetailsList() && Objects.equals(this.packageDetailsList(), other.packageDetailsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePackagesResponse").add("PackageDetailsList", this.hasPackageDetailsList() ? this.packageDetailsList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PackageDetailsList": {
                return Optional.ofNullable(clazz.cast(this.packageDetailsList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PackageDetailsList", PACKAGE_DETAILS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribePackagesResponse, T> g) {
        return obj -> g.apply((DescribePackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private List<PackageDetails> packageDetailsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePackagesResponse model) {
            super(model);
            this.packageDetailsList(model.packageDetailsList);
            this.nextToken(model.nextToken);
        }

        public final List<PackageDetails.Builder> getPackageDetailsList() {
            List<PackageDetails.Builder> result = PackageDetailsListCopier.copyToBuilder(this.packageDetailsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageDetailsList(Collection<PackageDetails.BuilderImpl> packageDetailsList) {
            this.packageDetailsList = PackageDetailsListCopier.copyFromBuilder(packageDetailsList);
        }

        @Override
        public final Builder packageDetailsList(Collection<PackageDetails> packageDetailsList) {
            this.packageDetailsList = PackageDetailsListCopier.copy(packageDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageDetailsList(PackageDetails ... packageDetailsList) {
            this.packageDetailsList(Arrays.asList(packageDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageDetailsList(Consumer<PackageDetails.Builder> ... packageDetailsList) {
            this.packageDetailsList(Stream.of(packageDetailsList).map(c -> (PackageDetails)((PackageDetails.Builder)PackageDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePackagesResponse build() {
            return new DescribePackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePackagesResponse> {
        public Builder packageDetailsList(Collection<PackageDetails> var1);

        public Builder packageDetailsList(PackageDetails ... var1);

        public Builder packageDetailsList(Consumer<PackageDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

