/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Credentials for the master user: username and password, ARN, or both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MasterUserOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<MasterUserOptions.Builder, MasterUserOptions> {
    private static final SdkField<String> MASTER_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserARN").getter(getter(MasterUserOptions::masterUserARN)).setter(setter(Builder::masterUserARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserARN").build()).build();

    private static final SdkField<String> MASTER_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserName").getter(getter(MasterUserOptions::masterUserName))
            .setter(setter(Builder::masterUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserName").build()).build();

    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUserPassword").getter(getter(MasterUserOptions::masterUserPassword))
            .setter(setter(Builder::masterUserPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MASTER_USER_ARN_FIELD,
            MASTER_USER_NAME_FIELD, MASTER_USER_PASSWORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String masterUserARN;

    private final String masterUserName;

    private final String masterUserPassword;

    private MasterUserOptions(BuilderImpl builder) {
        this.masterUserARN = builder.masterUserARN;
        this.masterUserName = builder.masterUserName;
        this.masterUserPassword = builder.masterUserPassword;
    }

    /**
     * <p>
     * ARN for the master user (if IAM is enabled).
     * </p>
     * 
     * @return ARN for the master user (if IAM is enabled).
     */
    public final String masterUserARN() {
        return masterUserARN;
    }

    /**
     * <p>
     * The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal database.
     * </p>
     * 
     * @return The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal
     *         database.
     */
    public final String masterUserName() {
        return masterUserName;
    }

    /**
     * <p>
     * The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal database.
     * </p>
     * 
     * @return The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal
     *         database.
     */
    public final String masterUserPassword() {
        return masterUserPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(masterUserARN());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserName());
        hashCode = 31 * hashCode + Objects.hashCode(masterUserPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MasterUserOptions)) {
            return false;
        }
        MasterUserOptions other = (MasterUserOptions) obj;
        return Objects.equals(masterUserARN(), other.masterUserARN()) && Objects.equals(masterUserName(), other.masterUserName())
                && Objects.equals(masterUserPassword(), other.masterUserPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MasterUserOptions").add("MasterUserARN", masterUserARN())
                .add("MasterUserName", masterUserName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MasterUserPassword", masterUserPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MasterUserARN":
            return Optional.ofNullable(clazz.cast(masterUserARN()));
        case "MasterUserName":
            return Optional.ofNullable(clazz.cast(masterUserName()));
        case "MasterUserPassword":
            return Optional.ofNullable(clazz.cast(masterUserPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MasterUserOptions, T> g) {
        return obj -> g.apply((MasterUserOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MasterUserOptions> {
        /**
         * <p>
         * ARN for the master user (if IAM is enabled).
         * </p>
         * 
         * @param masterUserARN
         *        ARN for the master user (if IAM is enabled).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserARN(String masterUserARN);

        /**
         * <p>
         * The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal database.
         * </p>
         * 
         * @param masterUserName
         *        The master user's username, which is stored in the Amazon Elasticsearch Service domain's internal
         *        database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserName(String masterUserName);

        /**
         * <p>
         * The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal database.
         * </p>
         * 
         * @param masterUserPassword
         *        The master user's password, which is stored in the Amazon Elasticsearch Service domain's internal
         *        database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUserPassword(String masterUserPassword);
    }

    static final class BuilderImpl implements Builder {
        private String masterUserARN;

        private String masterUserName;

        private String masterUserPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(MasterUserOptions model) {
            masterUserARN(model.masterUserARN);
            masterUserName(model.masterUserName);
            masterUserPassword(model.masterUserPassword);
        }

        public final String getMasterUserARN() {
            return masterUserARN;
        }

        public final void setMasterUserARN(String masterUserARN) {
            this.masterUserARN = masterUserARN;
        }

        @Override
        @Transient
        public final Builder masterUserARN(String masterUserARN) {
            this.masterUserARN = masterUserARN;
            return this;
        }

        public final String getMasterUserName() {
            return masterUserName;
        }

        public final void setMasterUserName(String masterUserName) {
            this.masterUserName = masterUserName;
        }

        @Override
        @Transient
        public final Builder masterUserName(String masterUserName) {
            this.masterUserName = masterUserName;
            return this;
        }

        public final String getMasterUserPassword() {
            return masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        @Transient
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        @Override
        public MasterUserOptions build() {
            return new MasterUserOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
