/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configured log publishing options for the domain and their current status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogPublishingOptionsStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<LogPublishingOptionsStatus.Builder, LogPublishingOptionsStatus> {
    private static final SdkField<Map<String, LogPublishingOption>> OPTIONS_FIELD = SdkField
            .<Map<String, LogPublishingOption>> builder(MarshallingType.MAP)
            .memberName("Options")
            .getter(getter(LogPublishingOptionsStatus::optionsAsStrings))
            .setter(setter(Builder::optionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LogPublishingOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogPublishingOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.<OptionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(LogPublishingOptionsStatus::status)).setter(setter(Builder::status))
            .constructor(OptionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, LogPublishingOption> options;

    private final OptionStatus status;

    private LogPublishingOptionsStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    /**
     * <p>
     * The log publishing options configured for the Elasticsearch domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The log publishing options configured for the Elasticsearch domain.
     */
    public final Map<LogType, LogPublishingOption> options() {
        return LogPublishingOptionsCopier.copyStringToEnum(options);
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The log publishing options configured for the Elasticsearch domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The log publishing options configured for the Elasticsearch domain.
     */
    public final Map<String, LogPublishingOption> optionsAsStrings() {
        return options;
    }

    /**
     * <p>
     * The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the
     * status information that's included.
     * </p>
     * 
     * @return The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for
     *         the status information that's included.
     */
    public final OptionStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? optionsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogPublishingOptionsStatus)) {
            return false;
        }
        LogPublishingOptionsStatus other = (LogPublishingOptionsStatus) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(optionsAsStrings(), other.optionsAsStrings())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogPublishingOptionsStatus").add("Options", hasOptions() ? optionsAsStrings() : null)
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(optionsAsStrings()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogPublishingOptionsStatus, T> g) {
        return obj -> g.apply((LogPublishingOptionsStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogPublishingOptionsStatus> {
        /**
         * <p>
         * The log publishing options configured for the Elasticsearch domain.
         * </p>
         * 
         * @param options
         *        The log publishing options configured for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(Map<String, LogPublishingOption> options);

        /**
         * <p>
         * The log publishing options configured for the Elasticsearch domain.
         * </p>
         * 
         * @param options
         *        The log publishing options configured for the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Map<LogType, LogPublishingOption> options);

        /**
         * <p>
         * The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the
         * status information that's included.
         * </p>
         * 
         * @param status
         *        The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code>
         *        for the status information that's included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(OptionStatus status);

        /**
         * <p>
         * The status of the log publishing options for the Elasticsearch domain. See <code>OptionStatus</code> for the
         * status information that's included.
         * </p>
         * This is a convenience that creates an instance of the {@link OptionStatus.Builder} avoiding the need to
         * create one manually via {@link OptionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link OptionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(OptionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link OptionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(OptionStatus)
         */
        default Builder status(Consumer<OptionStatus.Builder> status) {
            return status(OptionStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, LogPublishingOption> options = DefaultSdkAutoConstructMap.getInstance();

        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(LogPublishingOptionsStatus model) {
            optionsWithStrings(model.options);
            status(model.status);
        }

        public final Map<String, LogPublishingOption.Builder> getOptions() {
            Map<String, LogPublishingOption.Builder> result = LogPublishingOptionsCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOptions(Map<String, LogPublishingOption.BuilderImpl> options) {
            this.options = LogPublishingOptionsCopier.copyFromBuilder(options);
        }

        @Override
        @Transient
        public final Builder optionsWithStrings(Map<String, LogPublishingOption> options) {
            this.options = LogPublishingOptionsCopier.copy(options);
            return this;
        }

        @Override
        @Transient
        public final Builder options(Map<LogType, LogPublishingOption> options) {
            this.options = LogPublishingOptionsCopier.copyEnumToString(options);
            return this;
        }

        public final OptionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public LogPublishingOptionsStatus build() {
            return new LogPublishingOptionsStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
