/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code> <a>ListElasticsearchInstanceTypes</a> </code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListElasticsearchInstanceTypesRequest extends ElasticsearchRequest implements
        ToCopyableBuilder<ListElasticsearchInstanceTypesRequest.Builder, ListElasticsearchInstanceTypesRequest> {
    private static final SdkField<String> ELASTICSEARCH_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElasticsearchVersion").getter(getter(ListElasticsearchInstanceTypesRequest::elasticsearchVersion))
            .setter(setter(Builder::elasticsearchVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ElasticsearchVersion").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(ListElasticsearchInstanceTypesRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("domainName").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListElasticsearchInstanceTypesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListElasticsearchInstanceTypesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTICSEARCH_VERSION_FIELD,
            DOMAIN_NAME_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String elasticsearchVersion;

    private final String domainName;

    private final Integer maxResults;

    private final String nextToken;

    private ListElasticsearchInstanceTypesRequest(BuilderImpl builder) {
        super(builder);
        this.elasticsearchVersion = builder.elasticsearchVersion;
        this.domainName = builder.domainName;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Version of Elasticsearch for which list of supported elasticsearch instance types are needed.
     * </p>
     * 
     * @return Version of Elasticsearch for which list of supported elasticsearch instance types are needed.
     */
    public final String elasticsearchVersion() {
        return elasticsearchVersion;
    }

    /**
     * <p>
     * DomainName represents the name of the Domain that we are trying to modify. This should be present only if we are
     * querying for list of available Elasticsearch instance types when modifying existing domain.
     * </p>
     * 
     * @return DomainName represents the name of the Domain that we are trying to modify. This should be present only if
     *         we are querying for list of available Elasticsearch instance types when modifying existing domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont be
     * honored.
     * </p>
     * 
     * @return Set this value to limit the number of results returned. Value provided must be greater than 30 else it
     *         wont be honored.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for
     * pagination.
     * </p>
     * 
     * @return NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for
     *         pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListElasticsearchInstanceTypesRequest)) {
            return false;
        }
        ListElasticsearchInstanceTypesRequest other = (ListElasticsearchInstanceTypesRequest) obj;
        return Objects.equals(elasticsearchVersion(), other.elasticsearchVersion())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListElasticsearchInstanceTypesRequest").add("ElasticsearchVersion", elasticsearchVersion())
                .add("DomainName", domainName()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticsearchVersion":
            return Optional.ofNullable(clazz.cast(elasticsearchVersion()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListElasticsearchInstanceTypesRequest, T> g) {
        return obj -> g.apply((ListElasticsearchInstanceTypesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListElasticsearchInstanceTypesRequest> {
        /**
         * <p>
         * Version of Elasticsearch for which list of supported elasticsearch instance types are needed.
         * </p>
         * 
         * @param elasticsearchVersion
         *        Version of Elasticsearch for which list of supported elasticsearch instance types are needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearchVersion(String elasticsearchVersion);

        /**
         * <p>
         * DomainName represents the name of the Domain that we are trying to modify. This should be present only if we
         * are querying for list of available Elasticsearch instance types when modifying existing domain.
         * </p>
         * 
         * @param domainName
         *        DomainName represents the name of the Domain that we are trying to modify. This should be present only
         *        if we are querying for list of available Elasticsearch instance types when modifying existing domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Set this value to limit the number of results returned. Value provided must be greater than 30 else it wont
         * be honored.
         * </p>
         * 
         * @param maxResults
         *        Set this value to limit the number of results returned. Value provided must be greater than 30 else it
         *        wont be honored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for
         * pagination.
         * </p>
         * 
         * @param nextToken
         *        NextToken should be sent in case if earlier API call produced result containing NextToken. It is used
         *        for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String elasticsearchVersion;

        private String domainName;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListElasticsearchInstanceTypesRequest model) {
            super(model);
            elasticsearchVersion(model.elasticsearchVersion);
            domainName(model.domainName);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getElasticsearchVersion() {
            return elasticsearchVersion;
        }

        public final void setElasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
        }

        @Override
        @Transient
        public final Builder elasticsearchVersion(String elasticsearchVersion) {
            this.elasticsearchVersion = elasticsearchVersion;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListElasticsearchInstanceTypesRequest build() {
            return new ListElasticsearchInstanceTypesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
