/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for results from <code>DescribeReservedElasticsearchInstances</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedElasticsearchInstancesResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<DescribeReservedElasticsearchInstancesResponse.Builder, DescribeReservedElasticsearchInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReservedElasticsearchInstancesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ReservedElasticsearchInstance>> RESERVED_ELASTICSEARCH_INSTANCES_FIELD = SdkField
            .<List<ReservedElasticsearchInstance>> builder(MarshallingType.LIST)
            .memberName("ReservedElasticsearchInstances")
            .getter(getter(DescribeReservedElasticsearchInstancesResponse::reservedElasticsearchInstances))
            .setter(setter(Builder::reservedElasticsearchInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedElasticsearchInstances")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservedElasticsearchInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedElasticsearchInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESERVED_ELASTICSEARCH_INSTANCES_FIELD));

    private final String nextToken;

    private final List<ReservedElasticsearchInstance> reservedElasticsearchInstances;

    private DescribeReservedElasticsearchInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedElasticsearchInstances = builder.reservedElasticsearchInstances;
    }

    /**
     * <p>
     * Provides an identifier to allow retrieval of paginated results.
     * </p>
     * 
     * @return Provides an identifier to allow retrieval of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedElasticsearchInstances property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReservedElasticsearchInstances() {
        return reservedElasticsearchInstances != null && !(reservedElasticsearchInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of reserved Elasticsearch instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedElasticsearchInstances} method.
     * </p>
     * 
     * @return List of reserved Elasticsearch instances.
     */
    public final List<ReservedElasticsearchInstance> reservedElasticsearchInstances() {
        return reservedElasticsearchInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReservedElasticsearchInstances() ? reservedElasticsearchInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstancesResponse)) {
            return false;
        }
        DescribeReservedElasticsearchInstancesResponse other = (DescribeReservedElasticsearchInstancesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasReservedElasticsearchInstances() == other.hasReservedElasticsearchInstances()
                && Objects.equals(reservedElasticsearchInstances(), other.reservedElasticsearchInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeReservedElasticsearchInstancesResponse")
                .add("NextToken", nextToken())
                .add("ReservedElasticsearchInstances",
                        hasReservedElasticsearchInstances() ? reservedElasticsearchInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ReservedElasticsearchInstances":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedElasticsearchInstancesResponse, T> g) {
        return obj -> g.apply((DescribeReservedElasticsearchInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedElasticsearchInstancesResponse> {
        /**
         * <p>
         * Provides an identifier to allow retrieval of paginated results.
         * </p>
         * 
         * @param nextToken
         *        Provides an identifier to allow retrieval of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of reserved Elasticsearch instances.
         * </p>
         * 
         * @param reservedElasticsearchInstances
         *        List of reserved Elasticsearch instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstances(Collection<ReservedElasticsearchInstance> reservedElasticsearchInstances);

        /**
         * <p>
         * List of reserved Elasticsearch instances.
         * </p>
         * 
         * @param reservedElasticsearchInstances
         *        List of reserved Elasticsearch instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstances(ReservedElasticsearchInstance... reservedElasticsearchInstances);

        /**
         * <p>
         * List of reserved Elasticsearch instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedElasticsearchInstance>.Builder}
         * avoiding the need to create one manually via {@link List<ReservedElasticsearchInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedElasticsearchInstance>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #reservedElasticsearchInstances(List<ReservedElasticsearchInstance>)}.
         * 
         * @param reservedElasticsearchInstances
         *        a consumer that will call methods on {@link List<ReservedElasticsearchInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedElasticsearchInstances(List<ReservedElasticsearchInstance>)
         */
        Builder reservedElasticsearchInstances(Consumer<ReservedElasticsearchInstance.Builder>... reservedElasticsearchInstances);
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ReservedElasticsearchInstance> reservedElasticsearchInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstancesResponse model) {
            super(model);
            nextToken(model.nextToken);
            reservedElasticsearchInstances(model.reservedElasticsearchInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedElasticsearchInstance.Builder> getReservedElasticsearchInstances() {
            List<ReservedElasticsearchInstance.Builder> result = ReservedElasticsearchInstanceListCopier
                    .copyToBuilder(this.reservedElasticsearchInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedElasticsearchInstances(
                Collection<ReservedElasticsearchInstance.BuilderImpl> reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances = ReservedElasticsearchInstanceListCopier
                    .copyFromBuilder(reservedElasticsearchInstances);
        }

        @Override
        @Transient
        public final Builder reservedElasticsearchInstances(
                Collection<ReservedElasticsearchInstance> reservedElasticsearchInstances) {
            this.reservedElasticsearchInstances = ReservedElasticsearchInstanceListCopier.copy(reservedElasticsearchInstances);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedElasticsearchInstances(ReservedElasticsearchInstance... reservedElasticsearchInstances) {
            reservedElasticsearchInstances(Arrays.asList(reservedElasticsearchInstances));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedElasticsearchInstances(
                Consumer<ReservedElasticsearchInstance.Builder>... reservedElasticsearchInstances) {
            reservedElasticsearchInstances(Stream.of(reservedElasticsearchInstances)
                    .map(c -> ReservedElasticsearchInstance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedElasticsearchInstancesResponse build() {
            return new DescribeReservedElasticsearchInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
