/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for parameters to <code>DescribeReservedElasticsearchInstances</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedElasticsearchInstancesRequest extends ElasticsearchRequest implements
        ToCopyableBuilder<DescribeReservedElasticsearchInstancesRequest.Builder, DescribeReservedElasticsearchInstancesRequest> {
    private static final SdkField<String> RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("ReservedElasticsearchInstanceId")
            .getter(getter(DescribeReservedElasticsearchInstancesRequest::reservedElasticsearchInstanceId))
            .setter(setter(Builder::reservedElasticsearchInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("reservationId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeReservedElasticsearchInstancesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeReservedElasticsearchInstancesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_ELASTICSEARCH_INSTANCE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String reservedElasticsearchInstanceId;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeReservedElasticsearchInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.reservedElasticsearchInstanceId = builder.reservedElasticsearchInstanceId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the
     * specified reserved Elasticsearch instance ID.
     * </p>
     * 
     * @return The reserved instance identifier filter value. Use this parameter to show only the reservation that
     *         matches the specified reserved Elasticsearch instance ID.
     */
    public final String reservedElasticsearchInstanceId() {
        return reservedElasticsearchInstanceId;
    }

    /**
     * <p>
     * Set this value to limit the number of results returned. If not specified, defaults to 100.
     * </p>
     * 
     * @return Set this value to limit the number of results returned. If not specified, defaults to 100.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for
     * pagination.
     * </p>
     * 
     * @return NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for
     *         pagination.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(reservedElasticsearchInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedElasticsearchInstancesRequest)) {
            return false;
        }
        DescribeReservedElasticsearchInstancesRequest other = (DescribeReservedElasticsearchInstancesRequest) obj;
        return Objects.equals(reservedElasticsearchInstanceId(), other.reservedElasticsearchInstanceId())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeReservedElasticsearchInstancesRequest")
                .add("ReservedElasticsearchInstanceId", reservedElasticsearchInstanceId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedElasticsearchInstanceId":
            return Optional.ofNullable(clazz.cast(reservedElasticsearchInstanceId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedElasticsearchInstancesRequest, T> g) {
        return obj -> g.apply((DescribeReservedElasticsearchInstancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedElasticsearchInstancesRequest> {
        /**
         * <p>
         * The reserved instance identifier filter value. Use this parameter to show only the reservation that matches
         * the specified reserved Elasticsearch instance ID.
         * </p>
         * 
         * @param reservedElasticsearchInstanceId
         *        The reserved instance identifier filter value. Use this parameter to show only the reservation that
         *        matches the specified reserved Elasticsearch instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId);

        /**
         * <p>
         * Set this value to limit the number of results returned. If not specified, defaults to 100.
         * </p>
         * 
         * @param maxResults
         *        Set this value to limit the number of results returned. If not specified, defaults to 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * NextToken should be sent in case if earlier API call produced result containing NextToken. It is used for
         * pagination.
         * </p>
         * 
         * @param nextToken
         *        NextToken should be sent in case if earlier API call produced result containing NextToken. It is used
         *        for pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticsearchRequest.BuilderImpl implements Builder {
        private String reservedElasticsearchInstanceId;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedElasticsearchInstancesRequest model) {
            super(model);
            reservedElasticsearchInstanceId(model.reservedElasticsearchInstanceId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getReservedElasticsearchInstanceId() {
            return reservedElasticsearchInstanceId;
        }

        public final void setReservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
        }

        @Override
        @Transient
        public final Builder reservedElasticsearchInstanceId(String reservedElasticsearchInstanceId) {
            this.reservedElasticsearchInstanceId = reservedElasticsearchInstanceId;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedElasticsearchInstancesRequest build() {
            return new DescribeReservedElasticsearchInstancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
