/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeElasticsearchDomain</code> request. Contains the status of the domain specified in the
 * request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticsearchDomainResponse extends ElasticsearchResponse implements
        ToCopyableBuilder<DescribeElasticsearchDomainResponse.Builder, DescribeElasticsearchDomainResponse> {
    private static final SdkField<ElasticsearchDomainStatus> DOMAIN_STATUS_FIELD = SdkField
            .<ElasticsearchDomainStatus> builder(MarshallingType.SDK_POJO).memberName("DomainStatus")
            .getter(getter(DescribeElasticsearchDomainResponse::domainStatus)).setter(setter(Builder::domainStatus))
            .constructor(ElasticsearchDomainStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATUS_FIELD));

    private final ElasticsearchDomainStatus domainStatus;

    private DescribeElasticsearchDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatus = builder.domainStatus;
    }

    /**
     * <p>
     * The current status of the Elasticsearch domain.
     * </p>
     * 
     * @return The current status of the Elasticsearch domain.
     */
    public final ElasticsearchDomainStatus domainStatus() {
        return domainStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchDomainResponse)) {
            return false;
        }
        DescribeElasticsearchDomainResponse other = (DescribeElasticsearchDomainResponse) obj;
        return Objects.equals(domainStatus(), other.domainStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeElasticsearchDomainResponse").add("DomainStatus", domainStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainStatus":
            return Optional.ofNullable(clazz.cast(domainStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchDomainResponse, T> g) {
        return obj -> g.apply((DescribeElasticsearchDomainResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeElasticsearchDomainResponse> {
        /**
         * <p>
         * The current status of the Elasticsearch domain.
         * </p>
         * 
         * @param domainStatus
         *        The current status of the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainStatus(ElasticsearchDomainStatus domainStatus);

        /**
         * <p>
         * The current status of the Elasticsearch domain.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchDomainStatus.Builder} avoiding the
         * need to create one manually via {@link ElasticsearchDomainStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchDomainStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #domainStatus(ElasticsearchDomainStatus)}.
         * 
         * @param domainStatus
         *        a consumer that will call methods on {@link ElasticsearchDomainStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainStatus(ElasticsearchDomainStatus)
         */
        default Builder domainStatus(Consumer<ElasticsearchDomainStatus.Builder> domainStatus) {
            return domainStatus(ElasticsearchDomainStatus.builder().applyMutation(domainStatus).build());
        }
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private ElasticsearchDomainStatus domainStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchDomainResponse model) {
            super(model);
            domainStatus(model.domainStatus);
        }

        public final ElasticsearchDomainStatus.Builder getDomainStatus() {
            return domainStatus != null ? domainStatus.toBuilder() : null;
        }

        public final void setDomainStatus(ElasticsearchDomainStatus.BuilderImpl domainStatus) {
            this.domainStatus = domainStatus != null ? domainStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder domainStatus(ElasticsearchDomainStatus domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public DescribeElasticsearchDomainResponse build() {
            return new DescribeElasticsearchDomainResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
