/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code><a>DeleteOutboundCrossClusterSearchConnection</a></code> operation. Contains details of deleted
 * outbound connection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteOutboundCrossClusterSearchConnectionResponse extends ElasticsearchResponse
        implements
        ToCopyableBuilder<DeleteOutboundCrossClusterSearchConnectionResponse.Builder, DeleteOutboundCrossClusterSearchConnectionResponse> {
    private static final SdkField<OutboundCrossClusterSearchConnection> CROSS_CLUSTER_SEARCH_CONNECTION_FIELD = SdkField
            .<OutboundCrossClusterSearchConnection> builder(MarshallingType.SDK_POJO)
            .memberName("CrossClusterSearchConnection")
            .getter(getter(DeleteOutboundCrossClusterSearchConnectionResponse::crossClusterSearchConnection))
            .setter(setter(Builder::crossClusterSearchConnection))
            .constructor(OutboundCrossClusterSearchConnection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossClusterSearchConnection")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CROSS_CLUSTER_SEARCH_CONNECTION_FIELD));

    private final OutboundCrossClusterSearchConnection crossClusterSearchConnection;

    private DeleteOutboundCrossClusterSearchConnectionResponse(BuilderImpl builder) {
        super(builder);
        this.crossClusterSearchConnection = builder.crossClusterSearchConnection;
    }

    /**
     * <p>
     * Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection.
     * </p>
     * 
     * @return Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection.
     */
    public final OutboundCrossClusterSearchConnection crossClusterSearchConnection() {
        return crossClusterSearchConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(crossClusterSearchConnection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOutboundCrossClusterSearchConnectionResponse)) {
            return false;
        }
        DeleteOutboundCrossClusterSearchConnectionResponse other = (DeleteOutboundCrossClusterSearchConnectionResponse) obj;
        return Objects.equals(crossClusterSearchConnection(), other.crossClusterSearchConnection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteOutboundCrossClusterSearchConnectionResponse")
                .add("CrossClusterSearchConnection", crossClusterSearchConnection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrossClusterSearchConnection":
            return Optional.ofNullable(clazz.cast(crossClusterSearchConnection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteOutboundCrossClusterSearchConnectionResponse, T> g) {
        return obj -> g.apply((DeleteOutboundCrossClusterSearchConnectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticsearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteOutboundCrossClusterSearchConnectionResponse> {
        /**
         * <p>
         * Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection.
         * </p>
         * 
         * @param crossClusterSearchConnection
         *        Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossClusterSearchConnection(OutboundCrossClusterSearchConnection crossClusterSearchConnection);

        /**
         * <p>
         * Specifies the <code><a>OutboundCrossClusterSearchConnection</a></code> of deleted outbound connection.
         * </p>
         * This is a convenience that creates an instance of the {@link OutboundCrossClusterSearchConnection.Builder}
         * avoiding the need to create one manually via {@link OutboundCrossClusterSearchConnection#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutboundCrossClusterSearchConnection.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #crossClusterSearchConnection(OutboundCrossClusterSearchConnection)}.
         * 
         * @param crossClusterSearchConnection
         *        a consumer that will call methods on {@link OutboundCrossClusterSearchConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crossClusterSearchConnection(OutboundCrossClusterSearchConnection)
         */
        default Builder crossClusterSearchConnection(
                Consumer<OutboundCrossClusterSearchConnection.Builder> crossClusterSearchConnection) {
            return crossClusterSearchConnection(OutboundCrossClusterSearchConnection.builder()
                    .applyMutation(crossClusterSearchConnection).build());
        }
    }

    static final class BuilderImpl extends ElasticsearchResponse.BuilderImpl implements Builder {
        private OutboundCrossClusterSearchConnection crossClusterSearchConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOutboundCrossClusterSearchConnectionResponse model) {
            super(model);
            crossClusterSearchConnection(model.crossClusterSearchConnection);
        }

        public final OutboundCrossClusterSearchConnection.Builder getCrossClusterSearchConnection() {
            return crossClusterSearchConnection != null ? crossClusterSearchConnection.toBuilder() : null;
        }

        public final void setCrossClusterSearchConnection(
                OutboundCrossClusterSearchConnection.BuilderImpl crossClusterSearchConnection) {
            this.crossClusterSearchConnection = crossClusterSearchConnection != null ? crossClusterSearchConnection.build()
                    : null;
        }

        @Override
        @Transient
        public final Builder crossClusterSearchConnection(OutboundCrossClusterSearchConnection crossClusterSearchConnection) {
            this.crossClusterSearchConnection = crossClusterSearchConnection;
            return this;
        }

        @Override
        public DeleteOutboundCrossClusterSearchConnectionResponse build() {
            return new DeleteOutboundCrossClusterSearchConnectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
