/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticsearch.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options to specify the Cognito user and identity pools for Kibana authentication. For more information, see <a
 * href="http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-cognito-auth.html"
 * target="_blank">Amazon Cognito Authentication for Kibana</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CognitoOptions implements SdkPojo, Serializable, ToCopyableBuilder<CognitoOptions.Builder, CognitoOptions> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CognitoOptions::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> USER_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserPoolId").getter(getter(CognitoOptions::userPoolId)).setter(setter(Builder::userPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolId").build()).build();

    private static final SdkField<String> IDENTITY_POOL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityPoolId").getter(getter(CognitoOptions::identityPoolId)).setter(setter(Builder::identityPoolId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityPoolId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CognitoOptions::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            USER_POOL_ID_FIELD, IDENTITY_POOL_ID_FIELD, ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String userPoolId;

    private final String identityPoolId;

    private final String roleArn;

    private CognitoOptions(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.userPoolId = builder.userPoolId;
        this.identityPoolId = builder.identityPoolId;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * Specifies the option to enable Cognito for Kibana authentication.
     * </p>
     * 
     * @return Specifies the option to enable Cognito for Kibana authentication.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Specifies the Cognito user pool ID for Kibana authentication.
     * </p>
     * 
     * @return Specifies the Cognito user pool ID for Kibana authentication.
     */
    public final String userPoolId() {
        return userPoolId;
    }

    /**
     * <p>
     * Specifies the Cognito identity pool ID for Kibana authentication.
     * </p>
     * 
     * @return Specifies the Cognito identity pool ID for Kibana authentication.
     */
    public final String identityPoolId() {
        return identityPoolId;
    }

    /**
     * <p>
     * Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.
     * </p>
     * 
     * @return Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(identityPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoOptions)) {
            return false;
        }
        CognitoOptions other = (CognitoOptions) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(userPoolId(), other.userPoolId())
                && Objects.equals(identityPoolId(), other.identityPoolId()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CognitoOptions").add("Enabled", enabled()).add("UserPoolId", userPoolId())
                .add("IdentityPoolId", identityPoolId()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "UserPoolId":
            return Optional.ofNullable(clazz.cast(userPoolId()));
        case "IdentityPoolId":
            return Optional.ofNullable(clazz.cast(identityPoolId()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CognitoOptions, T> g) {
        return obj -> g.apply((CognitoOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CognitoOptions> {
        /**
         * <p>
         * Specifies the option to enable Cognito for Kibana authentication.
         * </p>
         * 
         * @param enabled
         *        Specifies the option to enable Cognito for Kibana authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Specifies the Cognito user pool ID for Kibana authentication.
         * </p>
         * 
         * @param userPoolId
         *        Specifies the Cognito user pool ID for Kibana authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolId(String userPoolId);

        /**
         * <p>
         * Specifies the Cognito identity pool ID for Kibana authentication.
         * </p>
         * 
         * @param identityPoolId
         *        Specifies the Cognito identity pool ID for Kibana authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityPoolId(String identityPoolId);

        /**
         * <p>
         * Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.
         * </p>
         * 
         * @param roleArn
         *        Specifies the role ARN that provides Elasticsearch permissions for accessing Cognito resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String userPoolId;

        private String identityPoolId;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoOptions model) {
            enabled(model.enabled);
            userPoolId(model.userPoolId);
            identityPoolId(model.identityPoolId);
            roleArn(model.roleArn);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getUserPoolId() {
            return userPoolId;
        }

        public final void setUserPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
        }

        @Override
        @Transient
        public final Builder userPoolId(String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        public final String getIdentityPoolId() {
            return identityPoolId;
        }

        public final void setIdentityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
        }

        @Override
        @Transient
        public final Builder identityPoolId(String identityPoolId) {
            this.identityPoolId = identityPoolId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public CognitoOptions build() {
            return new CognitoOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
