/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStore;

public class DescribeTrustStoresPublisher
implements SdkPublisher<DescribeTrustStoresResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeTrustStoresRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrustStoresPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTrustStoresRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrustStoresPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeTrustStoresRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrustStoresResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrustStoresResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrustStore> trustStores() {
        Function<DescribeTrustStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustStores() != null) {
                return response.trustStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTrustStoresResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTrustStoresResponseFetcher
    implements AsyncPageFetcher<DescribeTrustStoresResponse> {
        private DescribeTrustStoresResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeTrustStoresResponse> nextPage(DescribeTrustStoresResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustStoresPublisher.this.client.describeTrustStores(DescribeTrustStoresPublisher.this.firstRequest);
            }
            return DescribeTrustStoresPublisher.this.client.describeTrustStores((DescribeTrustStoresRequest)((Object)DescribeTrustStoresPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

