/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;

public class DescribeRulesIterable
implements SdkIterable<DescribeRulesResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRulesIterable(ElasticLoadBalancingV2Client client, DescribeRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRulesResponseFetcher();
    }

    public Iterator<DescribeRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Rule> rules() {
        Function<DescribeRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRulesResponseFetcher
    implements SyncPageFetcher<DescribeRulesResponse> {
        private DescribeRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeRulesResponse nextPage(DescribeRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRulesIterable.this.client.describeRules(DescribeRulesIterable.this.firstRequest);
            }
            return DescribeRulesIterable.this.client.describeRules((DescribeRulesRequest)((Object)DescribeRulesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

