/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.DefaultElasticLoadBalancingV2AsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface ElasticLoadBalancingV2AsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerAvailable(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerAvailable(Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) {
        return this.waitUntilLoadBalancerAvailable((DescribeLoadBalancersRequest)((Object)((DescribeLoadBalancersRequest.Builder)DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerAvailable(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerAvailable(Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilLoadBalancerAvailable((DescribeLoadBalancersRequest)((Object)((DescribeLoadBalancersRequest.Builder)DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerExists(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerExists(Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) {
        return this.waitUntilLoadBalancerExists((DescribeLoadBalancersRequest)((Object)((DescribeLoadBalancersRequest.Builder)DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerExists(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancerExists(Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilLoadBalancerExists((DescribeLoadBalancersRequest)((Object)((DescribeLoadBalancersRequest.Builder)DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancersDeleted(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancersDeleted(Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest) {
        return this.waitUntilLoadBalancersDeleted((DescribeLoadBalancersRequest)((Object)((DescribeLoadBalancersRequest.Builder)DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancersDeleted(DescribeLoadBalancersRequest describeLoadBalancersRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeLoadBalancersResponse>> waitUntilLoadBalancersDeleted(Consumer<DescribeLoadBalancersRequest.Builder> describeLoadBalancersRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilLoadBalancersDeleted((DescribeLoadBalancersRequest)((Object)((DescribeLoadBalancersRequest.Builder)DescribeLoadBalancersRequest.builder().applyMutation(describeLoadBalancersRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetDeregistered(DescribeTargetHealthRequest describeTargetHealthRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetDeregistered(Consumer<DescribeTargetHealthRequest.Builder> describeTargetHealthRequest) {
        return this.waitUntilTargetDeregistered((DescribeTargetHealthRequest)((Object)((DescribeTargetHealthRequest.Builder)DescribeTargetHealthRequest.builder().applyMutation(describeTargetHealthRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetDeregistered(DescribeTargetHealthRequest describeTargetHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetDeregistered(Consumer<DescribeTargetHealthRequest.Builder> describeTargetHealthRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilTargetDeregistered((DescribeTargetHealthRequest)((Object)((DescribeTargetHealthRequest.Builder)DescribeTargetHealthRequest.builder().applyMutation(describeTargetHealthRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetInService(DescribeTargetHealthRequest describeTargetHealthRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetInService(Consumer<DescribeTargetHealthRequest.Builder> describeTargetHealthRequest) {
        return this.waitUntilTargetInService((DescribeTargetHealthRequest)((Object)((DescribeTargetHealthRequest.Builder)DescribeTargetHealthRequest.builder().applyMutation(describeTargetHealthRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetInService(DescribeTargetHealthRequest describeTargetHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeTargetHealthResponse>> waitUntilTargetInService(Consumer<DescribeTargetHealthRequest.Builder> describeTargetHealthRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilTargetInService((DescribeTargetHealthRequest)((Object)((DescribeTargetHealthRequest.Builder)DescribeTargetHealthRequest.builder().applyMutation(describeTargetHealthRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultElasticLoadBalancingV2AsyncWaiter.builder();
    }

    public static ElasticLoadBalancingV2AsyncWaiter create() {
        return DefaultElasticLoadBalancingV2AsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(ElasticLoadBalancingV2AsyncClient var1);

        public ElasticLoadBalancingV2AsyncWaiter build();
    }
}

