/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpamPools;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveIpamPoolEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveIpamPoolsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyIpPoolsRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, ModifyIpPoolsRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(ModifyIpPoolsRequest.getter(ModifyIpPoolsRequest::loadBalancerArn)).setter(ModifyIpPoolsRequest.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<IpamPools> IPAM_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IpamPools").getter(ModifyIpPoolsRequest.getter(ModifyIpPoolsRequest::ipamPools)).setter(ModifyIpPoolsRequest.setter(Builder::ipamPools)).constructor(IpamPools::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPools").build()}).build();
    private static final SdkField<List<String>> REMOVE_IPAM_POOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveIpamPools").getter(ModifyIpPoolsRequest.getter(ModifyIpPoolsRequest::removeIpamPoolsAsStrings)).setter(ModifyIpPoolsRequest.setter(Builder::removeIpamPoolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveIpamPools").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, IPAM_POOLS_FIELD, REMOVE_IPAM_POOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyIpPoolsRequest.memberNameToFieldInitializer();
    private final String loadBalancerArn;
    private final IpamPools ipamPools;
    private final List<String> removeIpamPools;

    private ModifyIpPoolsRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.ipamPools = builder.ipamPools;
        this.removeIpamPools = builder.removeIpamPools;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final IpamPools ipamPools() {
        return this.ipamPools;
    }

    public final List<RemoveIpamPoolEnum> removeIpamPools() {
        return RemoveIpamPoolsCopier.copyStringToEnum(this.removeIpamPools);
    }

    public final boolean hasRemoveIpamPools() {
        return this.removeIpamPools != null && !(this.removeIpamPools instanceof SdkAutoConstructList);
    }

    public final List<String> removeIpamPoolsAsStrings() {
        return this.removeIpamPools;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipamPools());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveIpamPools() ? this.removeIpamPoolsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyIpPoolsRequest)) {
            return false;
        }
        ModifyIpPoolsRequest other = (ModifyIpPoolsRequest)((Object)obj);
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.ipamPools(), other.ipamPools()) && this.hasRemoveIpamPools() == other.hasRemoveIpamPools() && Objects.equals(this.removeIpamPoolsAsStrings(), other.removeIpamPoolsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyIpPoolsRequest").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("IpamPools", (Object)this.ipamPools()).add("RemoveIpamPools", this.hasRemoveIpamPools() ? this.removeIpamPoolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "IpamPools": {
                return Optional.ofNullable(clazz.cast(this.ipamPools()));
            }
            case "RemoveIpamPools": {
                return Optional.ofNullable(clazz.cast(this.removeIpamPoolsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerArn", LOAD_BALANCER_ARN_FIELD);
        map.put("IpamPools", IPAM_POOLS_FIELD);
        map.put("RemoveIpamPools", REMOVE_IPAM_POOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyIpPoolsRequest, T> g) {
        return obj -> g.apply((ModifyIpPoolsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private IpamPools ipamPools;
        private List<String> removeIpamPools = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyIpPoolsRequest model) {
            super(model);
            this.loadBalancerArn(model.loadBalancerArn);
            this.ipamPools(model.ipamPools);
            this.removeIpamPoolsWithStrings(model.removeIpamPools);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final IpamPools.Builder getIpamPools() {
            return this.ipamPools != null ? this.ipamPools.toBuilder() : null;
        }

        public final void setIpamPools(IpamPools.BuilderImpl ipamPools) {
            this.ipamPools = ipamPools != null ? ipamPools.build() : null;
        }

        @Override
        public final Builder ipamPools(IpamPools ipamPools) {
            this.ipamPools = ipamPools;
            return this;
        }

        public final Collection<String> getRemoveIpamPools() {
            if (this.removeIpamPools instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeIpamPools;
        }

        public final void setRemoveIpamPools(Collection<String> removeIpamPools) {
            this.removeIpamPools = RemoveIpamPoolsCopier.copy(removeIpamPools);
        }

        @Override
        public final Builder removeIpamPoolsWithStrings(Collection<String> removeIpamPools) {
            this.removeIpamPools = RemoveIpamPoolsCopier.copy(removeIpamPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIpamPoolsWithStrings(String ... removeIpamPools) {
            this.removeIpamPoolsWithStrings(Arrays.asList(removeIpamPools));
            return this;
        }

        @Override
        public final Builder removeIpamPools(Collection<RemoveIpamPoolEnum> removeIpamPools) {
            this.removeIpamPools = RemoveIpamPoolsCopier.copyEnumToString(removeIpamPools);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIpamPools(RemoveIpamPoolEnum ... removeIpamPools) {
            this.removeIpamPools(Arrays.asList(removeIpamPools));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyIpPoolsRequest build() {
            return new ModifyIpPoolsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyIpPoolsRequest> {
        public Builder loadBalancerArn(String var1);

        public Builder ipamPools(IpamPools var1);

        default public Builder ipamPools(Consumer<IpamPools.Builder> ipamPools) {
            return this.ipamPools((IpamPools)((IpamPools.Builder)IpamPools.builder().applyMutation(ipamPools)).build());
        }

        public Builder removeIpamPoolsWithStrings(Collection<String> var1);

        public Builder removeIpamPoolsWithStrings(String ... var1);

        public Builder removeIpamPools(Collection<RemoveIpamPoolEnum> var1);

        public Builder removeIpamPools(RemoveIpamPoolEnum ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

