/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Matcher
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Matcher> {
    private static final SdkField<String> HTTP_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpCode").getter(Matcher.getter(Matcher::httpCode)).setter(Matcher.setter(Builder::httpCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpCode").build()}).build();
    private static final SdkField<String> GRPC_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GrpcCode").getter(Matcher.getter(Matcher::grpcCode)).setter(Matcher.setter(Builder::grpcCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrpcCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_CODE_FIELD, GRPC_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Matcher.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String httpCode;
    private final String grpcCode;

    private Matcher(BuilderImpl builder) {
        this.httpCode = builder.httpCode;
        this.grpcCode = builder.grpcCode;
    }

    public final String httpCode() {
        return this.httpCode;
    }

    public final String grpcCode() {
        return this.grpcCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.grpcCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Matcher)) {
            return false;
        }
        Matcher other = (Matcher)obj;
        return Objects.equals(this.httpCode(), other.httpCode()) && Objects.equals(this.grpcCode(), other.grpcCode());
    }

    public final String toString() {
        return ToString.builder((String)"Matcher").add("HttpCode", (Object)this.httpCode()).add("GrpcCode", (Object)this.grpcCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpCode": {
                return Optional.ofNullable(clazz.cast(this.httpCode()));
            }
            case "GrpcCode": {
                return Optional.ofNullable(clazz.cast(this.grpcCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("HttpCode", HTTP_CODE_FIELD);
        map.put("GrpcCode", GRPC_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Matcher, T> g) {
        return obj -> g.apply((Matcher)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpCode;
        private String grpcCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Matcher model) {
            this.httpCode(model.httpCode);
            this.grpcCode(model.grpcCode);
        }

        public final String getHttpCode() {
            return this.httpCode;
        }

        public final void setHttpCode(String httpCode) {
            this.httpCode = httpCode;
        }

        @Override
        public final Builder httpCode(String httpCode) {
            this.httpCode = httpCode;
            return this;
        }

        public final String getGrpcCode() {
            return this.grpcCode;
        }

        public final void setGrpcCode(String grpcCode) {
            this.grpcCode = grpcCode;
        }

        @Override
        public final Builder grpcCode(String grpcCode) {
            this.grpcCode = grpcCode;
            return this;
        }

        public Matcher build() {
            return new Matcher(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Matcher> {
        public Builder httpCode(String var1);

        public Builder grpcCode(String var1);
    }
}

