/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Certificate;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;

public class DescribeListenerCertificatesPublisher
implements SdkPublisher<DescribeListenerCertificatesResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeListenerCertificatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeListenerCertificatesPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeListenerCertificatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeListenerCertificatesPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeListenerCertificatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeListenerCertificatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeListenerCertificatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Certificate> certificates() {
        Function<DescribeListenerCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.certificates() != null) {
                return response.certificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeListenerCertificatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeListenerCertificatesResponseFetcher
    implements AsyncPageFetcher<DescribeListenerCertificatesResponse> {
        private DescribeListenerCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeListenerCertificatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeListenerCertificatesResponse> nextPage(DescribeListenerCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeListenerCertificatesPublisher.this.client.describeListenerCertificates(DescribeListenerCertificatesPublisher.this.firstRequest);
            }
            return DescribeListenerCertificatesPublisher.this.client.describeListenerCertificates((DescribeListenerCertificatesRequest)((Object)DescribeListenerCertificatesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

