/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a redirect action.
 * </p>
 * <p>
 * A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the
 * following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not
 * modify retain their original values.
 * </p>
 * <p>
 * You can reuse URI components using the following reserved keywords:
 * </p>
 * <ul>
 * <li>
 * <p>
 * #{protocol}
 * </p>
 * </li>
 * <li>
 * <p>
 * #{host}
 * </p>
 * </li>
 * <li>
 * <p>
 * #{port}
 * </p>
 * </li>
 * <li>
 * <p>
 * #{path} (the leading "/" is removed)
 * </p>
 * </li>
 * <li>
 * <p>
 * #{query}
 * </p>
 * </li>
 * </ul>
 * <p>
 * For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to
 * "#{query}&amp;value=xyz".
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedirectActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RedirectActionConfig.Builder, RedirectActionConfig> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(RedirectActionConfig::protocol)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Port")
            .getter(getter(RedirectActionConfig::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(RedirectActionConfig::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(RedirectActionConfig::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Query")
            .getter(getter(RedirectActionConfig::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()).build();

    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusCode").getter(getter(RedirectActionConfig::statusCodeAsString))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, PORT_FIELD,
            HOST_FIELD, PATH_FIELD, QUERY_FIELD, STATUS_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final String port;

    private final String host;

    private final String path;

    private final String query;

    private final String statusCode;

    private RedirectActionConfig(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.host = builder.host;
        this.path = builder.path;
        this.query = builder.query;
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and
     * HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
     * </p>
     * 
     * @return The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS,
     *         and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
     */
    public final String protocol() {
        return protocol;
    }

    /**
     * <p>
     * The port. You can specify a value from 1 to 65535 or #{port}.
     * </p>
     * 
     * @return The port. You can specify a value from 1 to 65535 or #{port}.
     */
    public final String port() {
        return port;
    }

    /**
     * <p>
     * The hostname. This component is not percent-encoded. The hostname can contain #{host}.
     * </p>
     * 
     * @return The hostname. This component is not percent-encoded. The hostname can contain #{host}.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain
     * #{host}, #{path}, and #{port}.
     * </p>
     * 
     * @return The absolute path, starting with the leading "/". This component is not percent-encoded. The path can
     *         contain #{host}, #{path}, and #{port}.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it
     * is automatically added. You can specify any of the reserved keywords.
     * </p>
     * 
     * @return The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading
     *         "?", as it is automatically added. You can specify any of the reserved keywords.
     */
    public final String query() {
        return query;
    }

    /**
     * <p>
     * The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link RedirectActionStatusCodeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
     * @see RedirectActionStatusCodeEnum
     */
    public final RedirectActionStatusCodeEnum statusCode() {
        return RedirectActionStatusCodeEnum.fromValue(statusCode);
    }

    /**
     * <p>
     * The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusCode} will
     * return {@link RedirectActionStatusCodeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusCodeAsString}.
     * </p>
     * 
     * @return The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
     * @see RedirectActionStatusCodeEnum
     */
    public final String statusCodeAsString() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocol());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(query());
        hashCode = 31 * hashCode + Objects.hashCode(statusCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedirectActionConfig)) {
            return false;
        }
        RedirectActionConfig other = (RedirectActionConfig) obj;
        return Objects.equals(protocol(), other.protocol()) && Objects.equals(port(), other.port())
                && Objects.equals(host(), other.host()) && Objects.equals(path(), other.path())
                && Objects.equals(query(), other.query()) && Objects.equals(statusCodeAsString(), other.statusCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedirectActionConfig").add("Protocol", protocol()).add("Port", port()).add("Host", host())
                .add("Path", path()).add("Query", query()).add("StatusCode", statusCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocol()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Query":
            return Optional.ofNullable(clazz.cast(query()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedirectActionConfig, T> g) {
        return obj -> g.apply((RedirectActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedirectActionConfig> {
        /**
         * <p>
         * The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and
         * HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
         * </p>
         * 
         * @param protocol
         *        The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to
         *        HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The port. You can specify a value from 1 to 65535 or #{port}.
         * </p>
         * 
         * @param port
         *        The port. You can specify a value from 1 to 65535 or #{port}.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(String port);

        /**
         * <p>
         * The hostname. This component is not percent-encoded. The hostname can contain #{host}.
         * </p>
         * 
         * @param host
         *        The hostname. This component is not percent-encoded. The hostname can contain #{host}.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain
         * #{host}, #{path}, and #{port}.
         * </p>
         * 
         * @param path
         *        The absolute path, starting with the leading "/". This component is not percent-encoded. The path can
         *        contain #{host}, #{path}, and #{port}.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as
         * it is automatically added. You can specify any of the reserved keywords.
         * </p>
         * 
         * @param query
         *        The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading
         *        "?", as it is automatically added. You can specify any of the reserved keywords.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);

        /**
         * <p>
         * The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
         * </p>
         * 
         * @param statusCode
         *        The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
         * @see RedirectActionStatusCodeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedirectActionStatusCodeEnum
         */
        Builder statusCode(String statusCode);

        /**
         * <p>
         * The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
         * </p>
         * 
         * @param statusCode
         *        The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
         * @see RedirectActionStatusCodeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RedirectActionStatusCodeEnum
         */
        Builder statusCode(RedirectActionStatusCodeEnum statusCode);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private String port;

        private String host;

        private String path;

        private String query;

        private String statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(RedirectActionConfig model) {
            protocol(model.protocol);
            port(model.port);
            host(model.host);
            path(model.path);
            query(model.query);
            statusCode(model.statusCode);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final String getPort() {
            return port;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        @Transient
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getQuery() {
            return query;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        @Transient
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final String getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        @Transient
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        @Transient
        public final Builder statusCode(RedirectActionStatusCodeEnum statusCode) {
            this.statusCode(statusCode == null ? null : statusCode.toString());
            return this;
        }

        @Override
        public RedirectActionConfig build() {
            return new RedirectActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
