/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateListenerRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<CreateListenerRequest.Builder, CreateListenerRequest> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoadBalancerArn").getter(getter(CreateListenerRequest::loadBalancerArn))
            .setter(setter(Builder::loadBalancerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(CreateListenerRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(CreateListenerRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> SSL_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslPolicy").getter(getter(CreateListenerRequest::sslPolicy)).setter(setter(Builder::sslPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslPolicy").build()).build();

    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField
            .<List<Certificate>> builder(MarshallingType.LIST)
            .memberName("Certificates")
            .getter(getter(CreateListenerRequest::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Certificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Certificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Action>> DEFAULT_ACTIONS_FIELD = SdkField
            .<List<Action>> builder(MarshallingType.LIST)
            .memberName("DefaultActions")
            .getter(getter(CreateListenerRequest::defaultActions))
            .setter(setter(Builder::defaultActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Action> builder(MarshallingType.SDK_POJO)
                                            .constructor(Action::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALPN_POLICY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AlpnPolicy")
            .getter(getter(CreateListenerRequest::alpnPolicy))
            .setter(setter(Builder::alpnPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlpnPolicy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateListenerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD,
            PROTOCOL_FIELD, PORT_FIELD, SSL_POLICY_FIELD, CERTIFICATES_FIELD, DEFAULT_ACTIONS_FIELD, ALPN_POLICY_FIELD,
            TAGS_FIELD));

    private final String loadBalancerArn;

    private final String protocol;

    private final Integer port;

    private final String sslPolicy;

    private final List<Certificate> certificates;

    private final List<Action> defaultActions;

    private final List<String> alpnPolicy;

    private final List<Tag> tags;

    private CreateListenerRequest(BuilderImpl builder) {
        super(builder);
        this.loadBalancerArn = builder.loadBalancerArn;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.sslPolicy = builder.sslPolicy;
        this.certificates = builder.certificates;
        this.defaultActions = builder.defaultActions;
        this.alpnPolicy = builder.alpnPolicy;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the load balancer.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the load balancer.
     */
    public final String loadBalancerArn() {
        return loadBalancerArn;
    }

    /**
     * <p>
     * The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported
     * protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP.
     * You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a
     * Gateway Load Balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for connections from clients to the load balancer. For Application Load Balancers, the
     *         supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS,
     *         UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot
     *         specify a protocol for a Gateway Load Balancer.
     * @see ProtocolEnum
     */
    public final ProtocolEnum protocol() {
        return ProtocolEnum.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported
     * protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP.
     * You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a
     * Gateway Load Balancer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ProtocolEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for connections from clients to the load balancer. For Application Load Balancers, the
     *         supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS,
     *         UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot
     *         specify a protocol for a Gateway Load Balancer.
     * @see ProtocolEnum
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.
     * </p>
     * 
     * @return The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * 
     * @return [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     *         >Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     *         >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     */
    public final String sslPolicy() {
        return sslPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Certificates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate. Set
     * <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificates} method.
     * </p>
     * 
     * @return [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one
     *         certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>
     *         .
     */
    public final List<Certificate> certificates() {
        return certificates;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDefaultActions() {
        return defaultActions != null && !(defaultActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions for the default rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultActions} method.
     * </p>
     * 
     * @return The actions for the default rule.
     */
    public final List<Action> defaultActions() {
        return defaultActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AlpnPolicy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAlpnPolicy() {
        return alpnPolicy != null && !(alpnPolicy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy
     * name. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>HTTP1Only</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP2Only</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP2Optional</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HTTP2Preferred</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>None</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
     * >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAlpnPolicy} method.
     * </p>
     * 
     * @return [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one
     *         policy name. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>HTTP1Only</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP2Only</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP2Optional</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HTTP2Preferred</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>None</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
     *         >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
     */
    public final List<String> alpnPolicy() {
        return alpnPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the listener.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the listener.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(sslPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificates() ? certificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultActions() ? defaultActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAlpnPolicy() ? alpnPolicy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateListenerRequest)) {
            return false;
        }
        CreateListenerRequest other = (CreateListenerRequest) obj;
        return Objects.equals(loadBalancerArn(), other.loadBalancerArn())
                && Objects.equals(protocolAsString(), other.protocolAsString()) && Objects.equals(port(), other.port())
                && Objects.equals(sslPolicy(), other.sslPolicy()) && hasCertificates() == other.hasCertificates()
                && Objects.equals(certificates(), other.certificates()) && hasDefaultActions() == other.hasDefaultActions()
                && Objects.equals(defaultActions(), other.defaultActions()) && hasAlpnPolicy() == other.hasAlpnPolicy()
                && Objects.equals(alpnPolicy(), other.alpnPolicy()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateListenerRequest").add("LoadBalancerArn", loadBalancerArn())
                .add("Protocol", protocolAsString()).add("Port", port()).add("SslPolicy", sslPolicy())
                .add("Certificates", hasCertificates() ? certificates() : null)
                .add("DefaultActions", hasDefaultActions() ? defaultActions() : null)
                .add("AlpnPolicy", hasAlpnPolicy() ? alpnPolicy() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerArn":
            return Optional.ofNullable(clazz.cast(loadBalancerArn()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "SslPolicy":
            return Optional.ofNullable(clazz.cast(sslPolicy()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "DefaultActions":
            return Optional.ofNullable(clazz.cast(defaultActions()));
        case "AlpnPolicy":
            return Optional.ofNullable(clazz.cast(alpnPolicy()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateListenerRequest, T> g) {
        return obj -> g.apply((CreateListenerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateListenerRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the load balancer.
         * </p>
         * 
         * @param loadBalancerArn
         *        The Amazon Resource Name (ARN) of the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerArn(String loadBalancerArn);

        /**
         * <p>
         * The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported
         * protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and
         * TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a
         * protocol for a Gateway Load Balancer.
         * </p>
         * 
         * @param protocol
         *        The protocol for connections from clients to the load balancer. For Application Load Balancers, the
         *        supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP,
         *        TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled.
         *        You cannot specify a protocol for a Gateway Load Balancer.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported
         * protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and
         * TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a
         * protocol for a Gateway Load Balancer.
         * </p>
         * 
         * @param protocol
         *        The protocol for connections from clients to the load balancer. For Application Load Balancers, the
         *        supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP,
         *        TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled.
         *        You cannot specify a protocol for a Gateway Load Balancer.
         * @see ProtocolEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtocolEnum
         */
        Builder protocol(ProtocolEnum protocol);

        /**
         * <p>
         * The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.
         * </p>
         * 
         * @param port
         *        The port on which the load balancer is listening. You cannot specify a port for a Gateway Load
         *        Balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are supported.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
         * >Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
         * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
         * </p>
         * 
         * @param sslPolicy
         *        [HTTPS and TLS listeners] The security policy that defines which protocols and ciphers are
         *        supported.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
         *        >Security policies</a> in the <i>Application Load Balancers Guide</i> and <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
         *        >Security policies</a> in the <i>Network Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslPolicy(String sslPolicy);

        /**
         * <p>
         * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate.
         * Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * 
         * @param certificates
         *        [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one
         *        certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
         *        <code>IsDefault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<Certificate> certificates);

        /**
         * <p>
         * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate.
         * Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * 
         * @param certificates
         *        [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one
         *        certificate. Set <code>CertificateArn</code> to the certificate ARN but do not set
         *        <code>IsDefault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Certificate... certificates);

        /**
         * <p>
         * [HTTPS and TLS listeners] The default certificate for the listener. You must provide exactly one certificate.
         * Set <code>CertificateArn</code> to the certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Certificate>.Builder} avoiding the need to
         * create one manually via {@link List<Certificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Certificate>.Builder#build()} is called immediately and its
         * result is passed to {@link #certificates(List<Certificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link List<Certificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(List<Certificate>)
         */
        Builder certificates(Consumer<Certificate.Builder>... certificates);

        /**
         * <p>
         * The actions for the default rule.
         * </p>
         * 
         * @param defaultActions
         *        The actions for the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultActions(Collection<Action> defaultActions);

        /**
         * <p>
         * The actions for the default rule.
         * </p>
         * 
         * @param defaultActions
         *        The actions for the default rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultActions(Action... defaultActions);

        /**
         * <p>
         * The actions for the default rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Action>.Builder} avoiding the need to
         * create one manually via {@link List<Action>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Action>.Builder#build()} is called immediately and its
         * result is passed to {@link #defaultActions(List<Action>)}.
         * 
         * @param defaultActions
         *        a consumer that will call methods on {@link List<Action>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultActions(List<Action>)
         */
        Builder defaultActions(Consumer<Action.Builder>... defaultActions);

        /**
         * <p>
         * [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one
         * policy name. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HTTP1Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Optional</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Preferred</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>None</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
         * policies</a> in the <i>Network Load Balancers Guide</i>.
         * </p>
         * 
         * @param alpnPolicy
         *        [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify
         *        one policy name. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTP1Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Optional</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Preferred</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>None</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
         *        >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alpnPolicy(Collection<String> alpnPolicy);

        /**
         * <p>
         * [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one
         * policy name. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>HTTP1Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Only</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Optional</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HTTP2Preferred</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>None</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies">ALPN
         * policies</a> in the <i>Network Load Balancers Guide</i>.
         * </p>
         * 
         * @param alpnPolicy
         *        [TLS listeners] The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify
         *        one policy name. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>HTTP1Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Only</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Optional</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HTTP2Preferred</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>None</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies"
         *        >ALPN policies</a> in the <i>Network Load Balancers Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alpnPolicy(String... alpnPolicy);

        /**
         * <p>
         * The tags to assign to the listener.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to assign to the listener.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to assign to the listener.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String loadBalancerArn;

        private String protocol;

        private Integer port;

        private String sslPolicy;

        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private List<Action> defaultActions = DefaultSdkAutoConstructList.getInstance();

        private List<String> alpnPolicy = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateListenerRequest model) {
            super(model);
            loadBalancerArn(model.loadBalancerArn);
            protocol(model.protocol);
            port(model.port);
            sslPolicy(model.sslPolicy);
            certificates(model.certificates);
            defaultActions(model.defaultActions);
            alpnPolicy(model.alpnPolicy);
            tags(model.tags);
        }

        public final String getLoadBalancerArn() {
            return loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        @Transient
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @Transient
        public final Builder protocol(ProtocolEnum protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        @Transient
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSslPolicy() {
            return sslPolicy;
        }

        public final void setSslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
        }

        @Override
        @Transient
        public final Builder sslPolicy(String sslPolicy) {
            this.sslPolicy = sslPolicy;
            return this;
        }

        public final List<Certificate.Builder> getCertificates() {
            List<Certificate.Builder> result = CertificateListCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        @Override
        @Transient
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder certificates(Certificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> Certificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Action.Builder> getDefaultActions() {
            List<Action.Builder> result = ActionsCopier.copyToBuilder(this.defaultActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultActions(Collection<Action.BuilderImpl> defaultActions) {
            this.defaultActions = ActionsCopier.copyFromBuilder(defaultActions);
        }

        @Override
        @Transient
        public final Builder defaultActions(Collection<Action> defaultActions) {
            this.defaultActions = ActionsCopier.copy(defaultActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultActions(Action... defaultActions) {
            defaultActions(Arrays.asList(defaultActions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultActions(Consumer<Action.Builder>... defaultActions) {
            defaultActions(Stream.of(defaultActions).map(c -> Action.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAlpnPolicy() {
            if (alpnPolicy instanceof SdkAutoConstructList) {
                return null;
            }
            return alpnPolicy;
        }

        public final void setAlpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
        }

        @Override
        @Transient
        public final Builder alpnPolicy(Collection<String> alpnPolicy) {
            this.alpnPolicy = AlpnPolicyNameCopier.copy(alpnPolicy);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder alpnPolicy(String... alpnPolicy) {
            alpnPolicy(Arrays.asList(alpnPolicy));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateListenerRequest build() {
            return new CreateListenerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
