/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancing.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.elasticloadbalancing.ElasticLoadBalancingAsyncClient;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancing.waiters.DefaultElasticLoadBalancingAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface ElasticLoadBalancingAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilAnyInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilAnyInstanceInService(Consumer<DescribeInstanceHealthRequest.Builder> describeInstanceHealthRequest) {
        return this.waitUntilAnyInstanceInService((DescribeInstanceHealthRequest)((Object)((DescribeInstanceHealthRequest.Builder)DescribeInstanceHealthRequest.builder().applyMutation(describeInstanceHealthRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilAnyInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilAnyInstanceInService(Consumer<DescribeInstanceHealthRequest.Builder> describeInstanceHealthRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilAnyInstanceInService((DescribeInstanceHealthRequest)((Object)((DescribeInstanceHealthRequest.Builder)DescribeInstanceHealthRequest.builder().applyMutation(describeInstanceHealthRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceDeregistered(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceDeregistered(Consumer<DescribeInstanceHealthRequest.Builder> describeInstanceHealthRequest) {
        return this.waitUntilInstanceDeregistered((DescribeInstanceHealthRequest)((Object)((DescribeInstanceHealthRequest.Builder)DescribeInstanceHealthRequest.builder().applyMutation(describeInstanceHealthRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceDeregistered(DescribeInstanceHealthRequest describeInstanceHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceDeregistered(Consumer<DescribeInstanceHealthRequest.Builder> describeInstanceHealthRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilInstanceDeregistered((DescribeInstanceHealthRequest)((Object)((DescribeInstanceHealthRequest.Builder)DescribeInstanceHealthRequest.builder().applyMutation(describeInstanceHealthRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceInService(Consumer<DescribeInstanceHealthRequest.Builder> describeInstanceHealthRequest) {
        return this.waitUntilInstanceInService((DescribeInstanceHealthRequest)((Object)((DescribeInstanceHealthRequest.Builder)DescribeInstanceHealthRequest.builder().applyMutation(describeInstanceHealthRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceInService(DescribeInstanceHealthRequest describeInstanceHealthRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeInstanceHealthResponse>> waitUntilInstanceInService(Consumer<DescribeInstanceHealthRequest.Builder> describeInstanceHealthRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilInstanceInService((DescribeInstanceHealthRequest)((Object)((DescribeInstanceHealthRequest.Builder)DescribeInstanceHealthRequest.builder().applyMutation(describeInstanceHealthRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultElasticLoadBalancingAsyncWaiter.builder();
    }

    public static ElasticLoadBalancingAsyncWaiter create() {
        return DefaultElasticLoadBalancingAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(ElasticLoadBalancingAsyncClient var1);

        public ElasticLoadBalancingAsyncWaiter build();
    }
}

