/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AvailabilityZone;
import software.amazon.awssdk.services.elasticache.model.NetworkType;
import software.amazon.awssdk.services.elasticache.model.NetworkTypeListCopier;
import software.amazon.awssdk.services.elasticache.model.SubnetOutpost;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subnet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subnet> {
    private static final SdkField<String> SUBNET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetIdentifier").getter(Subnet.getter(Subnet::subnetIdentifier)).setter(Subnet.setter(Builder::subnetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIdentifier").build()}).build();
    private static final SdkField<AvailabilityZone> SUBNET_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubnetAvailabilityZone").getter(Subnet.getter(Subnet::subnetAvailabilityZone)).setter(Subnet.setter(Builder::subnetAvailabilityZone)).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetAvailabilityZone").build()}).build();
    private static final SdkField<SubnetOutpost> SUBNET_OUTPOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubnetOutpost").getter(Subnet.getter(Subnet::subnetOutpost)).setter(Subnet.setter(Builder::subnetOutpost)).constructor(SubnetOutpost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetOutpost").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_NETWORK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNetworkTypes").getter(Subnet.getter(Subnet::supportedNetworkTypesAsStrings)).setter(Subnet.setter(Builder::supportedNetworkTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNetworkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBNET_IDENTIFIER_FIELD, SUBNET_AVAILABILITY_ZONE_FIELD, SUBNET_OUTPOST_FIELD, SUPPORTED_NETWORK_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Subnet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subnetIdentifier;
    private final AvailabilityZone subnetAvailabilityZone;
    private final SubnetOutpost subnetOutpost;
    private final List<String> supportedNetworkTypes;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetOutpost = builder.subnetOutpost;
        this.supportedNetworkTypes = builder.supportedNetworkTypes;
    }

    public final String subnetIdentifier() {
        return this.subnetIdentifier;
    }

    public final AvailabilityZone subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public final SubnetOutpost subnetOutpost() {
        return this.subnetOutpost;
    }

    public final List<NetworkType> supportedNetworkTypes() {
        return NetworkTypeListCopier.copyStringToEnum(this.supportedNetworkTypes);
    }

    public final boolean hasSupportedNetworkTypes() {
        return this.supportedNetworkTypes != null && !(this.supportedNetworkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedNetworkTypesAsStrings() {
        return this.supportedNetworkTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetOutpost());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNetworkTypes() ? this.supportedNetworkTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.subnetIdentifier(), other.subnetIdentifier()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone()) && Objects.equals(this.subnetOutpost(), other.subnetOutpost()) && this.hasSupportedNetworkTypes() == other.hasSupportedNetworkTypes() && Objects.equals(this.supportedNetworkTypesAsStrings(), other.supportedNetworkTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"Subnet").add("SubnetIdentifier", (Object)this.subnetIdentifier()).add("SubnetAvailabilityZone", (Object)this.subnetAvailabilityZone()).add("SubnetOutpost", (Object)this.subnetOutpost()).add("SupportedNetworkTypes", this.hasSupportedNetworkTypes() ? this.supportedNetworkTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.subnetIdentifier()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZone()));
            }
            case "SubnetOutpost": {
                return Optional.ofNullable(clazz.cast(this.subnetOutpost()));
            }
            case "SupportedNetworkTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedNetworkTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubnetIdentifier", SUBNET_IDENTIFIER_FIELD);
        map.put("SubnetAvailabilityZone", SUBNET_AVAILABILITY_ZONE_FIELD);
        map.put("SubnetOutpost", SUBNET_OUTPOST_FIELD);
        map.put("SupportedNetworkTypes", SUPPORTED_NETWORK_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetIdentifier;
        private AvailabilityZone subnetAvailabilityZone;
        private SubnetOutpost subnetOutpost;
        private List<String> supportedNetworkTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.subnetIdentifier(model.subnetIdentifier);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
            this.subnetOutpost(model.subnetOutpost);
            this.supportedNetworkTypesWithStrings(model.supportedNetworkTypes);
        }

        public final String getSubnetIdentifier() {
            return this.subnetIdentifier;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final AvailabilityZone.Builder getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone != null ? this.subnetAvailabilityZone.toBuilder() : null;
        }

        public final void setSubnetAvailabilityZone(AvailabilityZone.BuilderImpl subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone != null ? subnetAvailabilityZone.build() : null;
        }

        @Override
        public final Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final SubnetOutpost.Builder getSubnetOutpost() {
            return this.subnetOutpost != null ? this.subnetOutpost.toBuilder() : null;
        }

        public final void setSubnetOutpost(SubnetOutpost.BuilderImpl subnetOutpost) {
            this.subnetOutpost = subnetOutpost != null ? subnetOutpost.build() : null;
        }

        @Override
        public final Builder subnetOutpost(SubnetOutpost subnetOutpost) {
            this.subnetOutpost = subnetOutpost;
            return this;
        }

        public final Collection<String> getSupportedNetworkTypes() {
            if (this.supportedNetworkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedNetworkTypes;
        }

        public final void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copy(supportedNetworkTypes);
        }

        @Override
        public final Builder supportedNetworkTypesWithStrings(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copy(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypesWithStrings(String ... supportedNetworkTypes) {
            this.supportedNetworkTypesWithStrings(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        @Override
        public final Builder supportedNetworkTypes(Collection<NetworkType> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copyEnumToString(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypes(NetworkType ... supportedNetworkTypes) {
            this.supportedNetworkTypes(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        public Subnet build() {
            return new Subnet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subnet> {
        public Builder subnetIdentifier(String var1);

        public Builder subnetAvailabilityZone(AvailabilityZone var1);

        default public Builder subnetAvailabilityZone(Consumer<AvailabilityZone.Builder> subnetAvailabilityZone) {
            return this.subnetAvailabilityZone((AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation(subnetAvailabilityZone)).build());
        }

        public Builder subnetOutpost(SubnetOutpost var1);

        default public Builder subnetOutpost(Consumer<SubnetOutpost.Builder> subnetOutpost) {
            return this.subnetOutpost((SubnetOutpost)((SubnetOutpost.Builder)SubnetOutpost.builder().applyMutation(subnetOutpost)).build());
        }

        public Builder supportedNetworkTypesWithStrings(Collection<String> var1);

        public Builder supportedNetworkTypesWithStrings(String ... var1);

        public Builder supportedNetworkTypes(Collection<NetworkType> var1);

        public Builder supportedNetworkTypes(NetworkType ... var1);
    }
}

