/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticache.ElastiCacheClient;
import software.amazon.awssdk.services.elasticache.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersRequest;
import software.amazon.awssdk.services.elasticache.model.DescribeCacheParametersResponse;
import software.amazon.awssdk.services.elasticache.model.Parameter;

public class DescribeCacheParametersIterable
implements SdkIterable<DescribeCacheParametersResponse> {
    private final ElastiCacheClient client;
    private final DescribeCacheParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeCacheParametersIterable(ElastiCacheClient client, DescribeCacheParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeCacheParametersResponseFetcher();
    }

    public Iterator<DescribeCacheParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeCacheParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeCacheParametersResponseFetcher
    implements SyncPageFetcher<DescribeCacheParametersResponse> {
        private DescribeCacheParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCacheParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeCacheParametersResponse nextPage(DescribeCacheParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeCacheParametersIterable.this.client.describeCacheParameters(DescribeCacheParametersIterable.this.firstRequest);
            }
            return DescribeCacheParametersIterable.this.client.describeCacheParameters((DescribeCacheParametersRequest)((Object)DescribeCacheParametersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

