/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticache.model.AuthenticationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Authentication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Authentication> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Authentication.getter(Authentication::typeAsString)).setter(Authentication.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> PASSWORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PasswordCount").getter(Authentication.getter(Authentication::passwordCount)).setter(Authentication.setter(Builder::passwordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PASSWORD_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Authentication.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Integer passwordCount;

    private Authentication(BuilderImpl builder) {
        this.type = builder.type;
        this.passwordCount = builder.passwordCount;
    }

    public final AuthenticationType type() {
        return AuthenticationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer passwordCount() {
        return this.passwordCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Authentication)) {
            return false;
        }
        Authentication other = (Authentication)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.passwordCount(), other.passwordCount());
    }

    public final String toString() {
        return ToString.builder((String)"Authentication").add("Type", (Object)this.typeAsString()).add("PasswordCount", (Object)this.passwordCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "PasswordCount": {
                return Optional.ofNullable(clazz.cast(this.passwordCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("PasswordCount", PASSWORD_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Authentication, T> g) {
        return obj -> g.apply((Authentication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer passwordCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Authentication model) {
            this.type(model.type);
            this.passwordCount(model.passwordCount);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AuthenticationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getPasswordCount() {
            return this.passwordCount;
        }

        public final void setPasswordCount(Integer passwordCount) {
            this.passwordCount = passwordCount;
        }

        @Override
        public final Builder passwordCount(Integer passwordCount) {
            this.passwordCount = passwordCount;
            return this;
        }

        public Authentication build() {
            return new Authentication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Authentication> {
        public Builder type(String var1);

        public Builder type(AuthenticationType var1);

        public Builder passwordCount(Integer var1);
    }
}

