/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eksauth;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.eksauth.EksAuthClient;
import software.amazon.awssdk.services.eksauth.EksAuthServiceClientConfiguration;
import software.amazon.awssdk.services.eksauth.internal.EksAuthServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.eksauth.model.AccessDeniedException;
import software.amazon.awssdk.services.eksauth.model.AssumeRoleForPodIdentityRequest;
import software.amazon.awssdk.services.eksauth.model.AssumeRoleForPodIdentityResponse;
import software.amazon.awssdk.services.eksauth.model.EksAuthException;
import software.amazon.awssdk.services.eksauth.model.ExpiredTokenException;
import software.amazon.awssdk.services.eksauth.model.InternalServerException;
import software.amazon.awssdk.services.eksauth.model.InvalidParameterException;
import software.amazon.awssdk.services.eksauth.model.InvalidRequestException;
import software.amazon.awssdk.services.eksauth.model.InvalidTokenException;
import software.amazon.awssdk.services.eksauth.model.ResourceNotFoundException;
import software.amazon.awssdk.services.eksauth.model.ServiceUnavailableException;
import software.amazon.awssdk.services.eksauth.model.ThrottlingException;
import software.amazon.awssdk.services.eksauth.transform.AssumeRoleForPodIdentityRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEksAuthClient
implements EksAuthClient {
    private static final Logger log = Logger.loggerFor(DefaultEksAuthClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultEksAuthClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"EKS_Auth#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssumeRoleForPodIdentityResponse assumeRoleForPodIdentity(AssumeRoleForPodIdentityRequest assumeRoleForPodIdentityRequest) throws ThrottlingException, InvalidRequestException, AccessDeniedException, InternalServerException, InvalidTokenException, InvalidParameterException, ExpiredTokenException, ResourceNotFoundException, ServiceUnavailableException, AwsServiceException, SdkClientException, EksAuthException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssumeRoleForPodIdentityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ExpiredTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExpiredTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ExpiredTokenException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ServiceUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "InvalidRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidRequestException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)assumeRoleForPodIdentityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEksAuthClient.resolveMetricPublishers(clientConfiguration, assumeRoleForPodIdentityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EKS Auth");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssumeRoleForPodIdentity");
            AssumeRoleForPodIdentityResponse assumeRoleForPodIdentityResponse = (AssumeRoleForPodIdentityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssumeRoleForPodIdentity").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)assumeRoleForPodIdentityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssumeRoleForPodIdentityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return assumeRoleForPodIdentityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEksAuthClient.lambda$assumeRoleForPodIdentity$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "eks-auth";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        EksAuthServiceClientConfigurationBuilder serviceConfigBuilder = new EksAuthServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(EksAuthException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final EksAuthServiceClientConfiguration serviceClientConfiguration() {
        return new EksAuthServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$assumeRoleForPodIdentity$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

