/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.CapabilitySummary;
import software.amazon.awssdk.services.eks.model.ListCapabilitiesRequest;
import software.amazon.awssdk.services.eks.model.ListCapabilitiesResponse;

public class ListCapabilitiesIterable
implements SdkIterable<ListCapabilitiesResponse> {
    private final EksClient client;
    private final ListCapabilitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCapabilitiesIterable(EksClient client, ListCapabilitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCapabilitiesResponseFetcher();
    }

    public Iterator<ListCapabilitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CapabilitySummary> capabilities() {
        Function<ListCapabilitiesResponse, Iterator> getIterator = response -> {
            if (response != null && response.capabilities() != null) {
                return response.capabilities().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCapabilitiesResponseFetcher
    implements SyncPageFetcher<ListCapabilitiesResponse> {
        private ListCapabilitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCapabilitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCapabilitiesResponse nextPage(ListCapabilitiesResponse previousPage) {
            if (previousPage == null) {
                return ListCapabilitiesIterable.this.client.listCapabilities(ListCapabilitiesIterable.this.firstRequest);
            }
            return ListCapabilitiesIterable.this.client.listCapabilities((ListCapabilitiesRequest)((Object)ListCapabilitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

