/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.AutoScalingGroup;
import software.amazon.awssdk.services.eks.model.AutoScalingGroupListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodegroupResources
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodegroupResources> {
    private static final SdkField<List<AutoScalingGroup>> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoScalingGroups").getter(NodegroupResources.getter(NodegroupResources::autoScalingGroups)).setter(NodegroupResources.setter(Builder::autoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutoScalingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REMOTE_ACCESS_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("remoteAccessSecurityGroup").getter(NodegroupResources.getter(NodegroupResources::remoteAccessSecurityGroup)).setter(NodegroupResources.setter(Builder::remoteAccessSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccessSecurityGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUPS_FIELD, REMOTE_ACCESS_SECURITY_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodegroupResources.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AutoScalingGroup> autoScalingGroups;
    private final String remoteAccessSecurityGroup;

    private NodegroupResources(BuilderImpl builder) {
        this.autoScalingGroups = builder.autoScalingGroups;
        this.remoteAccessSecurityGroup = builder.remoteAccessSecurityGroup;
    }

    public final boolean hasAutoScalingGroups() {
        return this.autoScalingGroups != null && !(this.autoScalingGroups instanceof SdkAutoConstructList);
    }

    public final List<AutoScalingGroup> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public final String remoteAccessSecurityGroup() {
        return this.remoteAccessSecurityGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroups() ? this.autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccessSecurityGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodegroupResources)) {
            return false;
        }
        NodegroupResources other = (NodegroupResources)obj;
        return this.hasAutoScalingGroups() == other.hasAutoScalingGroups() && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.remoteAccessSecurityGroup(), other.remoteAccessSecurityGroup());
    }

    public final String toString() {
        return ToString.builder((String)"NodegroupResources").add("AutoScalingGroups", this.hasAutoScalingGroups() ? this.autoScalingGroups() : null).add("RemoteAccessSecurityGroup", (Object)this.remoteAccessSecurityGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "autoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "remoteAccessSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.remoteAccessSecurityGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("autoScalingGroups", AUTO_SCALING_GROUPS_FIELD);
        map.put("remoteAccessSecurityGroup", REMOTE_ACCESS_SECURITY_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodegroupResources, T> g) {
        return obj -> g.apply((NodegroupResources)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AutoScalingGroup> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();
        private String remoteAccessSecurityGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(NodegroupResources model) {
            this.autoScalingGroups(model.autoScalingGroups);
            this.remoteAccessSecurityGroup(model.remoteAccessSecurityGroup);
        }

        public final List<AutoScalingGroup.Builder> getAutoScalingGroups() {
            List<AutoScalingGroup.Builder> result = AutoScalingGroupListCopier.copyToBuilder(this.autoScalingGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoScalingGroups(Collection<AutoScalingGroup.BuilderImpl> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copyFromBuilder(autoScalingGroups);
        }

        @Override
        public final Builder autoScalingGroups(Collection<AutoScalingGroup> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(AutoScalingGroup ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... autoScalingGroups) {
            this.autoScalingGroups(Stream.of(autoScalingGroups).map(c -> (AutoScalingGroup)((AutoScalingGroup.Builder)AutoScalingGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRemoteAccessSecurityGroup() {
            return this.remoteAccessSecurityGroup;
        }

        public final void setRemoteAccessSecurityGroup(String remoteAccessSecurityGroup) {
            this.remoteAccessSecurityGroup = remoteAccessSecurityGroup;
        }

        @Override
        public final Builder remoteAccessSecurityGroup(String remoteAccessSecurityGroup) {
            this.remoteAccessSecurityGroup = remoteAccessSecurityGroup;
            return this;
        }

        public NodegroupResources build() {
            return new NodegroupResources(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodegroupResources> {
        public Builder autoScalingGroups(Collection<AutoScalingGroup> var1);

        public Builder autoScalingGroups(AutoScalingGroup ... var1);

        public Builder autoScalingGroups(Consumer<AutoScalingGroup.Builder> ... var1);

        public Builder remoteAccessSecurityGroup(String var1);
    }
}

