/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.RepairAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeRepairConfigOverrides
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeRepairConfigOverrides> {
    private static final SdkField<String> NODE_MONITORING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeMonitoringCondition").getter(NodeRepairConfigOverrides.getter(NodeRepairConfigOverrides::nodeMonitoringCondition)).setter(NodeRepairConfigOverrides.setter(Builder::nodeMonitoringCondition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeMonitoringCondition").build()}).build();
    private static final SdkField<String> NODE_UNHEALTHY_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeUnhealthyReason").getter(NodeRepairConfigOverrides.getter(NodeRepairConfigOverrides::nodeUnhealthyReason)).setter(NodeRepairConfigOverrides.setter(Builder::nodeUnhealthyReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeUnhealthyReason").build()}).build();
    private static final SdkField<Integer> MIN_REPAIR_WAIT_TIME_MINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minRepairWaitTimeMins").getter(NodeRepairConfigOverrides.getter(NodeRepairConfigOverrides::minRepairWaitTimeMins)).setter(NodeRepairConfigOverrides.setter(Builder::minRepairWaitTimeMins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minRepairWaitTimeMins").build()}).build();
    private static final SdkField<String> REPAIR_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repairAction").getter(NodeRepairConfigOverrides.getter(NodeRepairConfigOverrides::repairActionAsString)).setter(NodeRepairConfigOverrides.setter(Builder::repairAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repairAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_MONITORING_CONDITION_FIELD, NODE_UNHEALTHY_REASON_FIELD, MIN_REPAIR_WAIT_TIME_MINS_FIELD, REPAIR_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeRepairConfigOverrides.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String nodeMonitoringCondition;
    private final String nodeUnhealthyReason;
    private final Integer minRepairWaitTimeMins;
    private final String repairAction;

    private NodeRepairConfigOverrides(BuilderImpl builder) {
        this.nodeMonitoringCondition = builder.nodeMonitoringCondition;
        this.nodeUnhealthyReason = builder.nodeUnhealthyReason;
        this.minRepairWaitTimeMins = builder.minRepairWaitTimeMins;
        this.repairAction = builder.repairAction;
    }

    public final String nodeMonitoringCondition() {
        return this.nodeMonitoringCondition;
    }

    public final String nodeUnhealthyReason() {
        return this.nodeUnhealthyReason;
    }

    public final Integer minRepairWaitTimeMins() {
        return this.minRepairWaitTimeMins;
    }

    public final RepairAction repairAction() {
        return RepairAction.fromValue(this.repairAction);
    }

    public final String repairActionAsString() {
        return this.repairAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeMonitoringCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeUnhealthyReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.minRepairWaitTimeMins());
        hashCode = 31 * hashCode + Objects.hashCode(this.repairActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRepairConfigOverrides)) {
            return false;
        }
        NodeRepairConfigOverrides other = (NodeRepairConfigOverrides)obj;
        return Objects.equals(this.nodeMonitoringCondition(), other.nodeMonitoringCondition()) && Objects.equals(this.nodeUnhealthyReason(), other.nodeUnhealthyReason()) && Objects.equals(this.minRepairWaitTimeMins(), other.minRepairWaitTimeMins()) && Objects.equals(this.repairActionAsString(), other.repairActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NodeRepairConfigOverrides").add("NodeMonitoringCondition", (Object)this.nodeMonitoringCondition()).add("NodeUnhealthyReason", (Object)this.nodeUnhealthyReason()).add("MinRepairWaitTimeMins", (Object)this.minRepairWaitTimeMins()).add("RepairAction", (Object)this.repairActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nodeMonitoringCondition": {
                return Optional.ofNullable(clazz.cast(this.nodeMonitoringCondition()));
            }
            case "nodeUnhealthyReason": {
                return Optional.ofNullable(clazz.cast(this.nodeUnhealthyReason()));
            }
            case "minRepairWaitTimeMins": {
                return Optional.ofNullable(clazz.cast(this.minRepairWaitTimeMins()));
            }
            case "repairAction": {
                return Optional.ofNullable(clazz.cast(this.repairActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nodeMonitoringCondition", NODE_MONITORING_CONDITION_FIELD);
        map.put("nodeUnhealthyReason", NODE_UNHEALTHY_REASON_FIELD);
        map.put("minRepairWaitTimeMins", MIN_REPAIR_WAIT_TIME_MINS_FIELD);
        map.put("repairAction", REPAIR_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeRepairConfigOverrides, T> g) {
        return obj -> g.apply((NodeRepairConfigOverrides)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String nodeMonitoringCondition;
        private String nodeUnhealthyReason;
        private Integer minRepairWaitTimeMins;
        private String repairAction;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRepairConfigOverrides model) {
            this.nodeMonitoringCondition(model.nodeMonitoringCondition);
            this.nodeUnhealthyReason(model.nodeUnhealthyReason);
            this.minRepairWaitTimeMins(model.minRepairWaitTimeMins);
            this.repairAction(model.repairAction);
        }

        public final String getNodeMonitoringCondition() {
            return this.nodeMonitoringCondition;
        }

        public final void setNodeMonitoringCondition(String nodeMonitoringCondition) {
            this.nodeMonitoringCondition = nodeMonitoringCondition;
        }

        @Override
        public final Builder nodeMonitoringCondition(String nodeMonitoringCondition) {
            this.nodeMonitoringCondition = nodeMonitoringCondition;
            return this;
        }

        public final String getNodeUnhealthyReason() {
            return this.nodeUnhealthyReason;
        }

        public final void setNodeUnhealthyReason(String nodeUnhealthyReason) {
            this.nodeUnhealthyReason = nodeUnhealthyReason;
        }

        @Override
        public final Builder nodeUnhealthyReason(String nodeUnhealthyReason) {
            this.nodeUnhealthyReason = nodeUnhealthyReason;
            return this;
        }

        public final Integer getMinRepairWaitTimeMins() {
            return this.minRepairWaitTimeMins;
        }

        public final void setMinRepairWaitTimeMins(Integer minRepairWaitTimeMins) {
            this.minRepairWaitTimeMins = minRepairWaitTimeMins;
        }

        @Override
        public final Builder minRepairWaitTimeMins(Integer minRepairWaitTimeMins) {
            this.minRepairWaitTimeMins = minRepairWaitTimeMins;
            return this;
        }

        public final String getRepairAction() {
            return this.repairAction;
        }

        public final void setRepairAction(String repairAction) {
            this.repairAction = repairAction;
        }

        @Override
        public final Builder repairAction(String repairAction) {
            this.repairAction = repairAction;
            return this;
        }

        @Override
        public final Builder repairAction(RepairAction repairAction) {
            this.repairAction(repairAction == null ? null : repairAction.toString());
            return this;
        }

        public NodeRepairConfigOverrides build() {
            return new NodeRepairConfigOverrides(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeRepairConfigOverrides> {
        public Builder nodeMonitoringCondition(String var1);

        public Builder nodeUnhealthyReason(String var1);

        public Builder minRepairWaitTimeMins(Integer var1);

        public Builder repairAction(String var1);

        public Builder repairAction(RepairAction var1);
    }
}

