/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ListPodIdentityAssociationsRequest;
import software.amazon.awssdk.services.eks.model.ListPodIdentityAssociationsResponse;
import software.amazon.awssdk.services.eks.model.PodIdentityAssociationSummary;

public class ListPodIdentityAssociationsPublisher
implements SdkPublisher<ListPodIdentityAssociationsResponse> {
    private final EksAsyncClient client;
    private final ListPodIdentityAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPodIdentityAssociationsPublisher(EksAsyncClient client, ListPodIdentityAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPodIdentityAssociationsPublisher(EksAsyncClient client, ListPodIdentityAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPodIdentityAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPodIdentityAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PodIdentityAssociationSummary> associations() {
        return this.flatMapIterable(response -> response.associations());
    }

    private class ListPodIdentityAssociationsResponseFetcher
    implements AsyncPageFetcher<ListPodIdentityAssociationsResponse> {
        private ListPodIdentityAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPodIdentityAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPodIdentityAssociationsResponse> nextPage(ListPodIdentityAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListPodIdentityAssociationsPublisher.this.client.listPodIdentityAssociations(ListPodIdentityAssociationsPublisher.this.firstRequest);
            }
            return ListPodIdentityAssociationsPublisher.this.client.listPodIdentityAssociations((ListPodIdentityAssociationsRequest)((Object)ListPodIdentityAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

