/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.InsightSummary;
import software.amazon.awssdk.services.eks.model.ListInsightsRequest;
import software.amazon.awssdk.services.eks.model.ListInsightsResponse;

public class ListInsightsPublisher
implements SdkPublisher<ListInsightsResponse> {
    private final EksAsyncClient client;
    private final ListInsightsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInsightsPublisher(EksAsyncClient client, ListInsightsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInsightsPublisher(EksAsyncClient client, ListInsightsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInsightsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInsightsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InsightSummary> insights() {
        return this.flatMapIterable(response -> response.insights());
    }

    private class ListInsightsResponseFetcher
    implements AsyncPageFetcher<ListInsightsResponse> {
        private ListInsightsResponseFetcher() {
        }

        public boolean hasNextPage(ListInsightsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInsightsResponse> nextPage(ListInsightsResponse previousPage) {
            if (previousPage == null) {
                return ListInsightsPublisher.this.client.listInsights(ListInsightsPublisher.this.firstRequest);
            }
            return ListInsightsPublisher.this.client.listInsights((ListInsightsRequest)((Object)ListInsightsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

