/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.CapabilitySummary;
import software.amazon.awssdk.services.eks.model.ListCapabilitiesRequest;
import software.amazon.awssdk.services.eks.model.ListCapabilitiesResponse;

public class ListCapabilitiesPublisher
implements SdkPublisher<ListCapabilitiesResponse> {
    private final EksAsyncClient client;
    private final ListCapabilitiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCapabilitiesPublisher(EksAsyncClient client, ListCapabilitiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCapabilitiesPublisher(EksAsyncClient client, ListCapabilitiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCapabilitiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCapabilitiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapabilitySummary> capabilities() {
        return this.flatMapIterable(response -> response.capabilities());
    }

    private class ListCapabilitiesResponseFetcher
    implements AsyncPageFetcher<ListCapabilitiesResponse> {
        private ListCapabilitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListCapabilitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCapabilitiesResponse> nextPage(ListCapabilitiesResponse previousPage) {
            if (previousPage == null) {
                return ListCapabilitiesPublisher.this.client.listCapabilities(ListCapabilitiesPublisher.this.firstRequest);
            }
            return ListCapabilitiesPublisher.this.client.listCapabilities((ListCapabilitiesRequest)((Object)ListCapabilitiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

