/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eks.model.AuthenticationMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessConfigRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateAccessConfigRequest> {
    private static final SdkField<Boolean> BOOTSTRAP_CLUSTER_CREATOR_ADMIN_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("bootstrapClusterCreatorAdminPermissions").getter(CreateAccessConfigRequest.getter(CreateAccessConfigRequest::bootstrapClusterCreatorAdminPermissions)).setter(CreateAccessConfigRequest.setter(Builder::bootstrapClusterCreatorAdminPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootstrapClusterCreatorAdminPermissions").build()}).build();
    private static final SdkField<String> AUTHENTICATION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationMode").getter(CreateAccessConfigRequest.getter(CreateAccessConfigRequest::authenticationModeAsString)).setter(CreateAccessConfigRequest.setter(Builder::authenticationMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOTSTRAP_CLUSTER_CREATOR_ADMIN_PERMISSIONS_FIELD, AUTHENTICATION_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccessConfigRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean bootstrapClusterCreatorAdminPermissions;
    private final String authenticationMode;

    private CreateAccessConfigRequest(BuilderImpl builder) {
        this.bootstrapClusterCreatorAdminPermissions = builder.bootstrapClusterCreatorAdminPermissions;
        this.authenticationMode = builder.authenticationMode;
    }

    public final Boolean bootstrapClusterCreatorAdminPermissions() {
        return this.bootstrapClusterCreatorAdminPermissions;
    }

    public final AuthenticationMode authenticationMode() {
        return AuthenticationMode.fromValue(this.authenticationMode);
    }

    public final String authenticationModeAsString() {
        return this.authenticationMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapClusterCreatorAdminPermissions());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessConfigRequest)) {
            return false;
        }
        CreateAccessConfigRequest other = (CreateAccessConfigRequest)obj;
        return Objects.equals(this.bootstrapClusterCreatorAdminPermissions(), other.bootstrapClusterCreatorAdminPermissions()) && Objects.equals(this.authenticationModeAsString(), other.authenticationModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessConfigRequest").add("BootstrapClusterCreatorAdminPermissions", (Object)this.bootstrapClusterCreatorAdminPermissions()).add("AuthenticationMode", (Object)this.authenticationModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bootstrapClusterCreatorAdminPermissions": {
                return Optional.ofNullable(clazz.cast(this.bootstrapClusterCreatorAdminPermissions()));
            }
            case "authenticationMode": {
                return Optional.ofNullable(clazz.cast(this.authenticationModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrapClusterCreatorAdminPermissions", BOOTSTRAP_CLUSTER_CREATOR_ADMIN_PERMISSIONS_FIELD);
        map.put("authenticationMode", AUTHENTICATION_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessConfigRequest, T> g) {
        return obj -> g.apply((CreateAccessConfigRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean bootstrapClusterCreatorAdminPermissions;
        private String authenticationMode;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessConfigRequest model) {
            this.bootstrapClusterCreatorAdminPermissions(model.bootstrapClusterCreatorAdminPermissions);
            this.authenticationMode(model.authenticationMode);
        }

        public final Boolean getBootstrapClusterCreatorAdminPermissions() {
            return this.bootstrapClusterCreatorAdminPermissions;
        }

        public final void setBootstrapClusterCreatorAdminPermissions(Boolean bootstrapClusterCreatorAdminPermissions) {
            this.bootstrapClusterCreatorAdminPermissions = bootstrapClusterCreatorAdminPermissions;
        }

        @Override
        public final Builder bootstrapClusterCreatorAdminPermissions(Boolean bootstrapClusterCreatorAdminPermissions) {
            this.bootstrapClusterCreatorAdminPermissions = bootstrapClusterCreatorAdminPermissions;
            return this;
        }

        public final String getAuthenticationMode() {
            return this.authenticationMode;
        }

        public final void setAuthenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
        }

        @Override
        public final Builder authenticationMode(String authenticationMode) {
            this.authenticationMode = authenticationMode;
            return this;
        }

        @Override
        public final Builder authenticationMode(AuthenticationMode authenticationMode) {
            this.authenticationMode(authenticationMode == null ? null : authenticationMode.toString());
            return this;
        }

        public CreateAccessConfigRequest build() {
            return new CreateAccessConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateAccessConfigRequest> {
        public Builder bootstrapClusterCreatorAdminPermissions(Boolean var1);

        public Builder authenticationMode(String var1);

        public Builder authenticationMode(AuthenticationMode var1);
    }
}

