/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArgoCdRole {
    ADMIN("ADMIN"),
    EDITOR("EDITOR"),
    VIEWER("VIEWER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArgoCdRole> VALUE_MAP;
    private final String value;

    private ArgoCdRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArgoCdRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArgoCdRole> knownValues() {
        EnumSet<ArgoCdRole> knownValues = EnumSet.allOf(ArgoCdRole.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArgoCdRole.class, ArgoCdRole::toString);
    }
}

