/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.NodeRepairConfigOverrides;
import software.amazon.awssdk.services.eks.model.NodeRepairConfigOverridesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeRepairConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeRepairConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(NodeRepairConfig.getter(NodeRepairConfig::enabled)).setter(NodeRepairConfig.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Integer> MAX_UNHEALTHY_NODE_THRESHOLD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxUnhealthyNodeThresholdCount").getter(NodeRepairConfig.getter(NodeRepairConfig::maxUnhealthyNodeThresholdCount)).setter(NodeRepairConfig.setter(Builder::maxUnhealthyNodeThresholdCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxUnhealthyNodeThresholdCount").build()}).build();
    private static final SdkField<Integer> MAX_UNHEALTHY_NODE_THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxUnhealthyNodeThresholdPercentage").getter(NodeRepairConfig.getter(NodeRepairConfig::maxUnhealthyNodeThresholdPercentage)).setter(NodeRepairConfig.setter(Builder::maxUnhealthyNodeThresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxUnhealthyNodeThresholdPercentage").build()}).build();
    private static final SdkField<Integer> MAX_PARALLEL_NODES_REPAIRED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxParallelNodesRepairedCount").getter(NodeRepairConfig.getter(NodeRepairConfig::maxParallelNodesRepairedCount)).setter(NodeRepairConfig.setter(Builder::maxParallelNodesRepairedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelNodesRepairedCount").build()}).build();
    private static final SdkField<Integer> MAX_PARALLEL_NODES_REPAIRED_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxParallelNodesRepairedPercentage").getter(NodeRepairConfig.getter(NodeRepairConfig::maxParallelNodesRepairedPercentage)).setter(NodeRepairConfig.setter(Builder::maxParallelNodesRepairedPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxParallelNodesRepairedPercentage").build()}).build();
    private static final SdkField<List<NodeRepairConfigOverrides>> NODE_REPAIR_CONFIG_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodeRepairConfigOverrides").getter(NodeRepairConfig.getter(NodeRepairConfig::nodeRepairConfigOverrides)).setter(NodeRepairConfig.setter(Builder::nodeRepairConfigOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeRepairConfigOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeRepairConfigOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, MAX_UNHEALTHY_NODE_THRESHOLD_COUNT_FIELD, MAX_UNHEALTHY_NODE_THRESHOLD_PERCENTAGE_FIELD, MAX_PARALLEL_NODES_REPAIRED_COUNT_FIELD, MAX_PARALLEL_NODES_REPAIRED_PERCENTAGE_FIELD, NODE_REPAIR_CONFIG_OVERRIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeRepairConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer maxUnhealthyNodeThresholdCount;
    private final Integer maxUnhealthyNodeThresholdPercentage;
    private final Integer maxParallelNodesRepairedCount;
    private final Integer maxParallelNodesRepairedPercentage;
    private final List<NodeRepairConfigOverrides> nodeRepairConfigOverrides;

    private NodeRepairConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.maxUnhealthyNodeThresholdCount = builder.maxUnhealthyNodeThresholdCount;
        this.maxUnhealthyNodeThresholdPercentage = builder.maxUnhealthyNodeThresholdPercentage;
        this.maxParallelNodesRepairedCount = builder.maxParallelNodesRepairedCount;
        this.maxParallelNodesRepairedPercentage = builder.maxParallelNodesRepairedPercentage;
        this.nodeRepairConfigOverrides = builder.nodeRepairConfigOverrides;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer maxUnhealthyNodeThresholdCount() {
        return this.maxUnhealthyNodeThresholdCount;
    }

    public final Integer maxUnhealthyNodeThresholdPercentage() {
        return this.maxUnhealthyNodeThresholdPercentage;
    }

    public final Integer maxParallelNodesRepairedCount() {
        return this.maxParallelNodesRepairedCount;
    }

    public final Integer maxParallelNodesRepairedPercentage() {
        return this.maxParallelNodesRepairedPercentage;
    }

    public final boolean hasNodeRepairConfigOverrides() {
        return this.nodeRepairConfigOverrides != null && !(this.nodeRepairConfigOverrides instanceof SdkAutoConstructList);
    }

    public final List<NodeRepairConfigOverrides> nodeRepairConfigOverrides() {
        return this.nodeRepairConfigOverrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUnhealthyNodeThresholdCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUnhealthyNodeThresholdPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelNodesRepairedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelNodesRepairedPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeRepairConfigOverrides() ? this.nodeRepairConfigOverrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeRepairConfig)) {
            return false;
        }
        NodeRepairConfig other = (NodeRepairConfig)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.maxUnhealthyNodeThresholdCount(), other.maxUnhealthyNodeThresholdCount()) && Objects.equals(this.maxUnhealthyNodeThresholdPercentage(), other.maxUnhealthyNodeThresholdPercentage()) && Objects.equals(this.maxParallelNodesRepairedCount(), other.maxParallelNodesRepairedCount()) && Objects.equals(this.maxParallelNodesRepairedPercentage(), other.maxParallelNodesRepairedPercentage()) && this.hasNodeRepairConfigOverrides() == other.hasNodeRepairConfigOverrides() && Objects.equals(this.nodeRepairConfigOverrides(), other.nodeRepairConfigOverrides());
    }

    public final String toString() {
        return ToString.builder((String)"NodeRepairConfig").add("Enabled", (Object)this.enabled()).add("MaxUnhealthyNodeThresholdCount", (Object)this.maxUnhealthyNodeThresholdCount()).add("MaxUnhealthyNodeThresholdPercentage", (Object)this.maxUnhealthyNodeThresholdPercentage()).add("MaxParallelNodesRepairedCount", (Object)this.maxParallelNodesRepairedCount()).add("MaxParallelNodesRepairedPercentage", (Object)this.maxParallelNodesRepairedPercentage()).add("NodeRepairConfigOverrides", this.hasNodeRepairConfigOverrides() ? this.nodeRepairConfigOverrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "maxUnhealthyNodeThresholdCount": {
                return Optional.ofNullable(clazz.cast(this.maxUnhealthyNodeThresholdCount()));
            }
            case "maxUnhealthyNodeThresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxUnhealthyNodeThresholdPercentage()));
            }
            case "maxParallelNodesRepairedCount": {
                return Optional.ofNullable(clazz.cast(this.maxParallelNodesRepairedCount()));
            }
            case "maxParallelNodesRepairedPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxParallelNodesRepairedPercentage()));
            }
            case "nodeRepairConfigOverrides": {
                return Optional.ofNullable(clazz.cast(this.nodeRepairConfigOverrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("maxUnhealthyNodeThresholdCount", MAX_UNHEALTHY_NODE_THRESHOLD_COUNT_FIELD);
        map.put("maxUnhealthyNodeThresholdPercentage", MAX_UNHEALTHY_NODE_THRESHOLD_PERCENTAGE_FIELD);
        map.put("maxParallelNodesRepairedCount", MAX_PARALLEL_NODES_REPAIRED_COUNT_FIELD);
        map.put("maxParallelNodesRepairedPercentage", MAX_PARALLEL_NODES_REPAIRED_PERCENTAGE_FIELD);
        map.put("nodeRepairConfigOverrides", NODE_REPAIR_CONFIG_OVERRIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeRepairConfig, T> g) {
        return obj -> g.apply((NodeRepairConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer maxUnhealthyNodeThresholdCount;
        private Integer maxUnhealthyNodeThresholdPercentage;
        private Integer maxParallelNodesRepairedCount;
        private Integer maxParallelNodesRepairedPercentage;
        private List<NodeRepairConfigOverrides> nodeRepairConfigOverrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeRepairConfig model) {
            this.enabled(model.enabled);
            this.maxUnhealthyNodeThresholdCount(model.maxUnhealthyNodeThresholdCount);
            this.maxUnhealthyNodeThresholdPercentage(model.maxUnhealthyNodeThresholdPercentage);
            this.maxParallelNodesRepairedCount(model.maxParallelNodesRepairedCount);
            this.maxParallelNodesRepairedPercentage(model.maxParallelNodesRepairedPercentage);
            this.nodeRepairConfigOverrides(model.nodeRepairConfigOverrides);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getMaxUnhealthyNodeThresholdCount() {
            return this.maxUnhealthyNodeThresholdCount;
        }

        public final void setMaxUnhealthyNodeThresholdCount(Integer maxUnhealthyNodeThresholdCount) {
            this.maxUnhealthyNodeThresholdCount = maxUnhealthyNodeThresholdCount;
        }

        @Override
        public final Builder maxUnhealthyNodeThresholdCount(Integer maxUnhealthyNodeThresholdCount) {
            this.maxUnhealthyNodeThresholdCount = maxUnhealthyNodeThresholdCount;
            return this;
        }

        public final Integer getMaxUnhealthyNodeThresholdPercentage() {
            return this.maxUnhealthyNodeThresholdPercentage;
        }

        public final void setMaxUnhealthyNodeThresholdPercentage(Integer maxUnhealthyNodeThresholdPercentage) {
            this.maxUnhealthyNodeThresholdPercentage = maxUnhealthyNodeThresholdPercentage;
        }

        @Override
        public final Builder maxUnhealthyNodeThresholdPercentage(Integer maxUnhealthyNodeThresholdPercentage) {
            this.maxUnhealthyNodeThresholdPercentage = maxUnhealthyNodeThresholdPercentage;
            return this;
        }

        public final Integer getMaxParallelNodesRepairedCount() {
            return this.maxParallelNodesRepairedCount;
        }

        public final void setMaxParallelNodesRepairedCount(Integer maxParallelNodesRepairedCount) {
            this.maxParallelNodesRepairedCount = maxParallelNodesRepairedCount;
        }

        @Override
        public final Builder maxParallelNodesRepairedCount(Integer maxParallelNodesRepairedCount) {
            this.maxParallelNodesRepairedCount = maxParallelNodesRepairedCount;
            return this;
        }

        public final Integer getMaxParallelNodesRepairedPercentage() {
            return this.maxParallelNodesRepairedPercentage;
        }

        public final void setMaxParallelNodesRepairedPercentage(Integer maxParallelNodesRepairedPercentage) {
            this.maxParallelNodesRepairedPercentage = maxParallelNodesRepairedPercentage;
        }

        @Override
        public final Builder maxParallelNodesRepairedPercentage(Integer maxParallelNodesRepairedPercentage) {
            this.maxParallelNodesRepairedPercentage = maxParallelNodesRepairedPercentage;
            return this;
        }

        public final List<NodeRepairConfigOverrides.Builder> getNodeRepairConfigOverrides() {
            List<NodeRepairConfigOverrides.Builder> result = NodeRepairConfigOverridesListCopier.copyToBuilder(this.nodeRepairConfigOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodeRepairConfigOverrides(Collection<NodeRepairConfigOverrides.BuilderImpl> nodeRepairConfigOverrides) {
            this.nodeRepairConfigOverrides = NodeRepairConfigOverridesListCopier.copyFromBuilder(nodeRepairConfigOverrides);
        }

        @Override
        public final Builder nodeRepairConfigOverrides(Collection<NodeRepairConfigOverrides> nodeRepairConfigOverrides) {
            this.nodeRepairConfigOverrides = NodeRepairConfigOverridesListCopier.copy(nodeRepairConfigOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRepairConfigOverrides(NodeRepairConfigOverrides ... nodeRepairConfigOverrides) {
            this.nodeRepairConfigOverrides(Arrays.asList(nodeRepairConfigOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeRepairConfigOverrides(Consumer<NodeRepairConfigOverrides.Builder> ... nodeRepairConfigOverrides) {
            this.nodeRepairConfigOverrides(Stream.of(nodeRepairConfigOverrides).map(c -> (NodeRepairConfigOverrides)((NodeRepairConfigOverrides.Builder)NodeRepairConfigOverrides.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NodeRepairConfig build() {
            return new NodeRepairConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeRepairConfig> {
        public Builder enabled(Boolean var1);

        public Builder maxUnhealthyNodeThresholdCount(Integer var1);

        public Builder maxUnhealthyNodeThresholdPercentage(Integer var1);

        public Builder maxParallelNodesRepairedCount(Integer var1);

        public Builder maxParallelNodesRepairedPercentage(Integer var1);

        public Builder nodeRepairConfigOverrides(Collection<NodeRepairConfigOverrides> var1);

        public Builder nodeRepairConfigOverrides(NodeRepairConfigOverrides ... var1);

        public Builder nodeRepairConfigOverrides(Consumer<NodeRepairConfigOverrides.Builder> ... var1);
    }
}

