/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.AssociatedAccessPoliciesListCopier;
import software.amazon.awssdk.services.eks.model.AssociatedAccessPolicy;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedAccessPoliciesResponse
extends EksResponse
implements ToCopyableBuilder<Builder, ListAssociatedAccessPoliciesResponse> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(ListAssociatedAccessPoliciesResponse.getter(ListAssociatedAccessPoliciesResponse::clusterName)).setter(ListAssociatedAccessPoliciesResponse.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(ListAssociatedAccessPoliciesResponse.getter(ListAssociatedAccessPoliciesResponse::principalArn)).setter(ListAssociatedAccessPoliciesResponse.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssociatedAccessPoliciesResponse.getter(ListAssociatedAccessPoliciesResponse::nextToken)).setter(ListAssociatedAccessPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AssociatedAccessPolicy>> ASSOCIATED_ACCESS_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedAccessPolicies").getter(ListAssociatedAccessPoliciesResponse.getter(ListAssociatedAccessPoliciesResponse::associatedAccessPolicies)).setter(ListAssociatedAccessPoliciesResponse.setter(Builder::associatedAccessPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAccessPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedAccessPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, PRINCIPAL_ARN_FIELD, NEXT_TOKEN_FIELD, ASSOCIATED_ACCESS_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssociatedAccessPoliciesResponse.memberNameToFieldInitializer();
    private final String clusterName;
    private final String principalArn;
    private final String nextToken;
    private final List<AssociatedAccessPolicy> associatedAccessPolicies;

    private ListAssociatedAccessPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.principalArn = builder.principalArn;
        this.nextToken = builder.nextToken;
        this.associatedAccessPolicies = builder.associatedAccessPolicies;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAssociatedAccessPolicies() {
        return this.associatedAccessPolicies != null && !(this.associatedAccessPolicies instanceof SdkAutoConstructList);
    }

    public final List<AssociatedAccessPolicy> associatedAccessPolicies() {
        return this.associatedAccessPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedAccessPolicies() ? this.associatedAccessPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedAccessPoliciesResponse)) {
            return false;
        }
        ListAssociatedAccessPoliciesResponse other = (ListAssociatedAccessPoliciesResponse)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasAssociatedAccessPolicies() == other.hasAssociatedAccessPolicies() && Objects.equals(this.associatedAccessPolicies(), other.associatedAccessPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedAccessPoliciesResponse").add("ClusterName", (Object)this.clusterName()).add("PrincipalArn", (Object)this.principalArn()).add("NextToken", (Object)this.nextToken()).add("AssociatedAccessPolicies", this.hasAssociatedAccessPolicies() ? this.associatedAccessPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "associatedAccessPolicies": {
                return Optional.ofNullable(clazz.cast(this.associatedAccessPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("principalArn", PRINCIPAL_ARN_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("associatedAccessPolicies", ASSOCIATED_ACCESS_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedAccessPoliciesResponse, T> g) {
        return obj -> g.apply((ListAssociatedAccessPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private String clusterName;
        private String principalArn;
        private String nextToken;
        private List<AssociatedAccessPolicy> associatedAccessPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedAccessPoliciesResponse model) {
            super(model);
            this.clusterName(model.clusterName);
            this.principalArn(model.principalArn);
            this.nextToken(model.nextToken);
            this.associatedAccessPolicies(model.associatedAccessPolicies);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AssociatedAccessPolicy.Builder> getAssociatedAccessPolicies() {
            List<AssociatedAccessPolicy.Builder> result = AssociatedAccessPoliciesListCopier.copyToBuilder(this.associatedAccessPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAccessPolicies(Collection<AssociatedAccessPolicy.BuilderImpl> associatedAccessPolicies) {
            this.associatedAccessPolicies = AssociatedAccessPoliciesListCopier.copyFromBuilder(associatedAccessPolicies);
        }

        @Override
        public final Builder associatedAccessPolicies(Collection<AssociatedAccessPolicy> associatedAccessPolicies) {
            this.associatedAccessPolicies = AssociatedAccessPoliciesListCopier.copy(associatedAccessPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedAccessPolicies(AssociatedAccessPolicy ... associatedAccessPolicies) {
            this.associatedAccessPolicies(Arrays.asList(associatedAccessPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedAccessPolicies(Consumer<AssociatedAccessPolicy.Builder> ... associatedAccessPolicies) {
            this.associatedAccessPolicies(Stream.of(associatedAccessPolicies).map(c -> (AssociatedAccessPolicy)((AssociatedAccessPolicy.Builder)AssociatedAccessPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAssociatedAccessPoliciesResponse build() {
            return new ListAssociatedAccessPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedAccessPoliciesResponse> {
        public Builder clusterName(String var1);

        public Builder principalArn(String var1);

        public Builder nextToken(String var1);

        public Builder associatedAccessPolicies(Collection<AssociatedAccessPolicy> var1);

        public Builder associatedAccessPolicies(AssociatedAccessPolicy ... var1);

        public Builder associatedAccessPolicies(Consumer<AssociatedAccessPolicy.Builder> ... var1);
    }
}

