/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.AddonInfo;
import software.amazon.awssdk.services.eks.model.AddonsCopier;
import software.amazon.awssdk.services.eks.model.EksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAddonVersionsResponse
extends EksResponse
implements ToCopyableBuilder<Builder, DescribeAddonVersionsResponse> {
    private static final SdkField<List<AddonInfo>> ADDONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("addons").getter(DescribeAddonVersionsResponse.getter(DescribeAddonVersionsResponse::addons)).setter(DescribeAddonVersionsResponse.setter(Builder::addons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddonInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeAddonVersionsResponse.getter(DescribeAddonVersionsResponse::nextToken)).setter(DescribeAddonVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAddonVersionsResponse.memberNameToFieldInitializer();
    private final List<AddonInfo> addons;
    private final String nextToken;

    private DescribeAddonVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.addons = builder.addons;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAddons() {
        return this.addons != null && !(this.addons instanceof SdkAutoConstructList);
    }

    public final List<AddonInfo> addons() {
        return this.addons;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddons() ? this.addons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddonVersionsResponse)) {
            return false;
        }
        DescribeAddonVersionsResponse other = (DescribeAddonVersionsResponse)((Object)obj);
        return this.hasAddons() == other.hasAddons() && Objects.equals(this.addons(), other.addons()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAddonVersionsResponse").add("Addons", this.hasAddons() ? this.addons() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "addons": {
                return Optional.ofNullable(clazz.cast(this.addons()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("addons", ADDONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAddonVersionsResponse, T> g) {
        return obj -> g.apply((DescribeAddonVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksResponse.BuilderImpl
    implements Builder {
        private List<AddonInfo> addons = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddonVersionsResponse model) {
            super(model);
            this.addons(model.addons);
            this.nextToken(model.nextToken);
        }

        public final List<AddonInfo.Builder> getAddons() {
            List<AddonInfo.Builder> result = AddonsCopier.copyToBuilder(this.addons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddons(Collection<AddonInfo.BuilderImpl> addons) {
            this.addons = AddonsCopier.copyFromBuilder(addons);
        }

        @Override
        public final Builder addons(Collection<AddonInfo> addons) {
            this.addons = AddonsCopier.copy(addons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addons(AddonInfo ... addons) {
            this.addons(Arrays.asList(addons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addons(Consumer<AddonInfo.Builder> ... addons) {
            this.addons(Stream.of(addons).map(c -> (AddonInfo)((AddonInfo.Builder)AddonInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAddonVersionsResponse build() {
            return new DescribeAddonVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAddonVersionsResponse> {
        public Builder addons(Collection<AddonInfo> var1);

        public Builder addons(AddonInfo ... var1);

        public Builder addons(Consumer<AddonInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

