/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.internal.UserAgentUtils;
import software.amazon.awssdk.services.eks.model.ClusterVersionInformation;
import software.amazon.awssdk.services.eks.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.eks.model.DescribeClusterVersionsResponse;

public class DescribeClusterVersionsPublisher
implements SdkPublisher<DescribeClusterVersionsResponse> {
    private final EksAsyncClient client;
    private final DescribeClusterVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterVersionsPublisher(EksAsyncClient client, DescribeClusterVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterVersionsPublisher(EksAsyncClient client, DescribeClusterVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClusterVersionInformation> clusterVersions() {
        Function<DescribeClusterVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterVersions() != null) {
                return response.clusterVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClusterVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeClusterVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterVersionsResponse> {
        private DescribeClusterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeClusterVersionsResponse> nextPage(DescribeClusterVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterVersionsPublisher.this.client.describeClusterVersions(DescribeClusterVersionsPublisher.this.firstRequest);
            }
            return DescribeClusterVersionsPublisher.this.client.describeClusterVersions((DescribeClusterVersionsRequest)((Object)DescribeClusterVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

