/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscriptionStatus;
import software.amazon.awssdk.services.eks.model.EksAnywhereSubscriptionStatusValuesCopier;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEksAnywhereSubscriptionsRequest
extends EksRequest
implements ToCopyableBuilder<Builder, ListEksAnywhereSubscriptionsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListEksAnywhereSubscriptionsRequest.getter(ListEksAnywhereSubscriptionsRequest::maxResults)).setter(ListEksAnywhereSubscriptionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEksAnywhereSubscriptionsRequest.getter(ListEksAnywhereSubscriptionsRequest::nextToken)).setter(ListEksAnywhereSubscriptionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> INCLUDE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("includeStatus").getter(ListEksAnywhereSubscriptionsRequest.getter(ListEksAnywhereSubscriptionsRequest::includeStatusAsStrings)).setter(ListEksAnywhereSubscriptionsRequest.setter(Builder::includeStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, INCLUDE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEksAnywhereSubscriptionsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> includeStatus;

    private ListEksAnywhereSubscriptionsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.includeStatus = builder.includeStatus;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final List<EksAnywhereSubscriptionStatus> includeStatus() {
        return EksAnywhereSubscriptionStatusValuesCopier.copyStringToEnum(this.includeStatus);
    }

    public final boolean hasIncludeStatus() {
        return this.includeStatus != null && !(this.includeStatus instanceof SdkAutoConstructList);
    }

    public final List<String> includeStatusAsStrings() {
        return this.includeStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncludeStatus() ? this.includeStatusAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEksAnywhereSubscriptionsRequest)) {
            return false;
        }
        ListEksAnywhereSubscriptionsRequest other = (ListEksAnywhereSubscriptionsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasIncludeStatus() == other.hasIncludeStatus() && Objects.equals(this.includeStatusAsStrings(), other.includeStatusAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ListEksAnywhereSubscriptionsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("IncludeStatus", this.hasIncludeStatus() ? this.includeStatusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "includeStatus": {
                return Optional.ofNullable(clazz.cast(this.includeStatusAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("includeStatus", INCLUDE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEksAnywhereSubscriptionsRequest, T> g) {
        return obj -> g.apply((ListEksAnywhereSubscriptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> includeStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEksAnywhereSubscriptionsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.includeStatusWithStrings(model.includeStatus);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getIncludeStatus() {
            if (this.includeStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.includeStatus;
        }

        public final void setIncludeStatus(Collection<String> includeStatus) {
            this.includeStatus = EksAnywhereSubscriptionStatusValuesCopier.copy(includeStatus);
        }

        @Override
        public final Builder includeStatusWithStrings(Collection<String> includeStatus) {
            this.includeStatus = EksAnywhereSubscriptionStatusValuesCopier.copy(includeStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeStatusWithStrings(String ... includeStatus) {
            this.includeStatusWithStrings(Arrays.asList(includeStatus));
            return this;
        }

        @Override
        public final Builder includeStatus(Collection<EksAnywhereSubscriptionStatus> includeStatus) {
            this.includeStatus = EksAnywhereSubscriptionStatusValuesCopier.copyEnumToString(includeStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeStatus(EksAnywhereSubscriptionStatus ... includeStatus) {
            this.includeStatus(Arrays.asList(includeStatus));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEksAnywhereSubscriptionsRequest build() {
            return new ListEksAnywhereSubscriptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEksAnywhereSubscriptionsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder includeStatusWithStrings(Collection<String> var1);

        public Builder includeStatusWithStrings(String ... var1);

        public Builder includeStatus(Collection<EksAnywhereSubscriptionStatus> var1);

        public Builder includeStatus(EksAnywhereSubscriptionStatus ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

