/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Compatibility
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Compatibility> {
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterVersion").getter(Compatibility.getter(Compatibility::clusterVersion)).setter(Compatibility.setter(Builder::clusterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterVersion").build()}).build();
    private static final SdkField<List<String>> PLATFORM_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("platformVersions").getter(Compatibility.getter(Compatibility::platformVersions)).setter(Compatibility.setter(Builder::platformVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platformVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DEFAULT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("defaultVersion").getter(Compatibility.getter(Compatibility::defaultVersion)).setter(Compatibility.setter(Builder::defaultVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_VERSION_FIELD, PLATFORM_VERSIONS_FIELD, DEFAULT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Compatibility.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterVersion;
    private final List<String> platformVersions;
    private final Boolean defaultVersion;

    private Compatibility(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.platformVersions = builder.platformVersions;
        this.defaultVersion = builder.defaultVersion;
    }

    public final String clusterVersion() {
        return this.clusterVersion;
    }

    public final boolean hasPlatformVersions() {
        return this.platformVersions != null && !(this.platformVersions instanceof SdkAutoConstructList);
    }

    public final List<String> platformVersions() {
        return this.platformVersions;
    }

    public final Boolean defaultVersion() {
        return this.defaultVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPlatformVersions() ? this.platformVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Compatibility)) {
            return false;
        }
        Compatibility other = (Compatibility)obj;
        return Objects.equals(this.clusterVersion(), other.clusterVersion()) && this.hasPlatformVersions() == other.hasPlatformVersions() && Objects.equals(this.platformVersions(), other.platformVersions()) && Objects.equals(this.defaultVersion(), other.defaultVersion());
    }

    public final String toString() {
        return ToString.builder((String)"Compatibility").add("ClusterVersion", (Object)this.clusterVersion()).add("PlatformVersions", this.hasPlatformVersions() ? this.platformVersions() : null).add("DefaultVersion", (Object)this.defaultVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "platformVersions": {
                return Optional.ofNullable(clazz.cast(this.platformVersions()));
            }
            case "defaultVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clusterVersion", CLUSTER_VERSION_FIELD);
        map.put("platformVersions", PLATFORM_VERSIONS_FIELD);
        map.put("defaultVersion", DEFAULT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Compatibility, T> g) {
        return obj -> g.apply((Compatibility)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private List<String> platformVersions = DefaultSdkAutoConstructList.getInstance();
        private Boolean defaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(Compatibility model) {
            this.clusterVersion(model.clusterVersion);
            this.platformVersions(model.platformVersions);
            this.defaultVersion(model.defaultVersion);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final Collection<String> getPlatformVersions() {
            if (this.platformVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.platformVersions;
        }

        public final void setPlatformVersions(Collection<String> platformVersions) {
            this.platformVersions = StringListCopier.copy(platformVersions);
        }

        @Override
        public final Builder platformVersions(Collection<String> platformVersions) {
            this.platformVersions = StringListCopier.copy(platformVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder platformVersions(String ... platformVersions) {
            this.platformVersions(Arrays.asList(platformVersions));
            return this;
        }

        public final Boolean getDefaultVersion() {
            return this.defaultVersion;
        }

        public final void setDefaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
        }

        @Override
        public final Builder defaultVersion(Boolean defaultVersion) {
            this.defaultVersion = defaultVersion;
            return this;
        }

        public Compatibility build() {
            return new Compatibility(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Compatibility> {
        public Builder clusterVersion(String var1);

        public Builder platformVersions(Collection<String> var1);

        public Builder platformVersions(String ... var1);

        public Builder defaultVersion(Boolean var1);
    }
}

