/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.eks.model.AccessScopeType;
import software.amazon.awssdk.services.eks.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccessScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccessScope> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AccessScope.getter(AccessScope::typeAsString)).setter(AccessScope.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> NAMESPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("namespaces").getter(AccessScope.getter(AccessScope::namespaces)).setter(AccessScope.setter(Builder::namespaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAMESPACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccessScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<String> namespaces;

    private AccessScope(BuilderImpl builder) {
        this.type = builder.type;
        this.namespaces = builder.namespaces;
    }

    public final AccessScopeType type() {
        return AccessScopeType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasNamespaces() {
        return this.namespaces != null && !(this.namespaces instanceof SdkAutoConstructList);
    }

    public final List<String> namespaces() {
        return this.namespaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNamespaces() ? this.namespaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScope)) {
            return false;
        }
        AccessScope other = (AccessScope)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasNamespaces() == other.hasNamespaces() && Objects.equals(this.namespaces(), other.namespaces());
    }

    public final String toString() {
        return ToString.builder((String)"AccessScope").add("Type", (Object)this.typeAsString()).add("Namespaces", this.hasNamespaces() ? this.namespaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "namespaces": {
                return Optional.ofNullable(clazz.cast(this.namespaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("namespaces", NAMESPACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessScope, T> g) {
        return obj -> g.apply((AccessScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<String> namespaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccessScope model) {
            this.type(model.type);
            this.namespaces(model.namespaces);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccessScopeType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getNamespaces() {
            if (this.namespaces instanceof SdkAutoConstructList) {
                return null;
            }
            return this.namespaces;
        }

        public final void setNamespaces(Collection<String> namespaces) {
            this.namespaces = StringListCopier.copy(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<String> namespaces) {
            this.namespaces = StringListCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(String ... namespaces) {
            this.namespaces(Arrays.asList(namespaces));
            return this;
        }

        public AccessScope build() {
            return new AccessScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccessScope> {
        public Builder type(String var1);

        public Builder type(AccessScopeType var1);

        public Builder namespaces(Collection<String> var1);

        public Builder namespaces(String ... var1);
    }
}

