/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UpdateType {
    VERSION_UPDATE("VersionUpdate"),
    ENDPOINT_ACCESS_UPDATE("EndpointAccessUpdate"),
    LOGGING_UPDATE("LoggingUpdate"),
    CONFIG_UPDATE("ConfigUpdate"),
    ASSOCIATE_IDENTITY_PROVIDER_CONFIG("AssociateIdentityProviderConfig"),
    DISASSOCIATE_IDENTITY_PROVIDER_CONFIG("DisassociateIdentityProviderConfig"),
    ASSOCIATE_ENCRYPTION_CONFIG("AssociateEncryptionConfig"),
    ADDON_UPDATE("AddonUpdate"),
    VPC_CONFIG_UPDATE("VpcConfigUpdate"),
    ACCESS_CONFIG_UPDATE("AccessConfigUpdate"),
    UPGRADE_POLICY_UPDATE("UpgradePolicyUpdate"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UpdateType> VALUE_MAP;
    private final String value;

    private UpdateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UpdateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UpdateType> knownValues() {
        EnumSet<UpdateType> knownValues = EnumSet.allOf(UpdateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UpdateType.class, UpdateType::toString);
    }
}

