/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPodIdentityAssociationsRequest extends EksRequest implements
        ToCopyableBuilder<ListPodIdentityAssociationsRequest.Builder, ListPodIdentityAssociationsRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterName").getter(getter(ListPodIdentityAssociationsRequest::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListPodIdentityAssociationsRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<String> SERVICE_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceAccount").getter(getter(ListPodIdentityAssociationsRequest::serviceAccount))
            .setter(setter(Builder::serviceAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("serviceAccount").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListPodIdentityAssociationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPodIdentityAssociationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            NAMESPACE_FIELD, SERVICE_ACCOUNT_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String clusterName;

    private final String namespace;

    private final String serviceAccount;

    private final Integer maxResults;

    private final String nextToken;

    private ListPodIdentityAssociationsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.namespace = builder.namespace;
        this.serviceAccount = builder.serviceAccount;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the cluster that the associations are in.
     * </p>
     * 
     * @return The name of the cluster that the associations are in.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * The name of the Kubernetes namespace inside the cluster that the associations are in.
     * </p>
     * 
     * @return The name of the Kubernetes namespace inside the cluster that the associations are in.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name of the Kubernetes service account that the associations use.
     * </p>
     * 
     * @return The name of the Kubernetes service account that the associations use.
     */
    public final String serviceAccount() {
        return serviceAccount;
    }

    /**
     * <p>
     * The maximum number of EKS Pod Identity association results returned by <code>ListPodIdentityAssociations</code>
     * in paginated output. When you use this parameter, <code>ListPodIdentityAssociations</code> returns only
     * <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. You can
     * see the remaining results of the initial request by sending another <code>ListPodIdentityAssociations</code>
     * request with the returned <code>nextToken</code> value. This value can be between 1 and 100. If you don't use
     * this parameter, <code>ListPodIdentityAssociations</code> returns up to 100 results and a <code>nextToken</code>
     * value if applicable.
     * </p>
     * 
     * @return The maximum number of EKS Pod Identity association results returned by
     *         <code>ListPodIdentityAssociations</code> in paginated output. When you use this parameter,
     *         <code>ListPodIdentityAssociations</code> returns only <code>maxResults</code> results in a single page
     *         along with a <code>nextToken</code> response element. You can see the remaining results of the initial
     *         request by sending another <code>ListPodIdentityAssociations</code> request with the returned
     *         <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter,
     *         <code>ListPodIdentityAssociations</code> returns up to 100 results and a <code>nextToken</code> value if
     *         applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request
     *         where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
     *         continues from the end of the previous results that returned the <code>nextToken</code> value.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is used only to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccount());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPodIdentityAssociationsRequest)) {
            return false;
        }
        ListPodIdentityAssociationsRequest other = (ListPodIdentityAssociationsRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(serviceAccount(), other.serviceAccount()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPodIdentityAssociationsRequest").add("ClusterName", clusterName())
                .add("Namespace", namespace()).add("ServiceAccount", serviceAccount()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "serviceAccount":
            return Optional.ofNullable(clazz.cast(serviceAccount()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPodIdentityAssociationsRequest, T> g) {
        return obj -> g.apply((ListPodIdentityAssociationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPodIdentityAssociationsRequest> {
        /**
         * <p>
         * The name of the cluster that the associations are in.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster that the associations are in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The name of the Kubernetes namespace inside the cluster that the associations are in.
         * </p>
         * 
         * @param namespace
         *        The name of the Kubernetes namespace inside the cluster that the associations are in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name of the Kubernetes service account that the associations use.
         * </p>
         * 
         * @param serviceAccount
         *        The name of the Kubernetes service account that the associations use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccount(String serviceAccount);

        /**
         * <p>
         * The maximum number of EKS Pod Identity association results returned by
         * <code>ListPodIdentityAssociations</code> in paginated output. When you use this parameter,
         * <code>ListPodIdentityAssociations</code> returns only <code>maxResults</code> results in a single page along
         * with a <code>nextToken</code> response element. You can see the remaining results of the initial request by
         * sending another <code>ListPodIdentityAssociations</code> request with the returned <code>nextToken</code>
         * value. This value can be between 1 and 100. If you don't use this parameter,
         * <code>ListPodIdentityAssociations</code> returns up to 100 results and a <code>nextToken</code> value if
         * applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of EKS Pod Identity association results returned by
         *        <code>ListPodIdentityAssociations</code> in paginated output. When you use this parameter,
         *        <code>ListPodIdentityAssociations</code> returns only <code>maxResults</code> results in a single page
         *        along with a <code>nextToken</code> response element. You can see the remaining results of the initial
         *        request by sending another <code>ListPodIdentityAssociations</code> request with the returned
         *        <code>nextToken</code> value. This value can be between 1 and 100. If you don't use this parameter,
         *        <code>ListPodIdentityAssociations</code> returns up to 100 results and a <code>nextToken</code> value
         *        if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request where
         * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues
         * from the end of the previous results that returned the <code>nextToken</code> value.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListUpdates</code> request
         *        where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is used only to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EksRequest.BuilderImpl implements Builder {
        private String clusterName;

        private String namespace;

        private String serviceAccount;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPodIdentityAssociationsRequest model) {
            super(model);
            clusterName(model.clusterName);
            namespace(model.namespace);
            serviceAccount(model.serviceAccount);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getServiceAccount() {
            return serviceAccount;
        }

        public final void setServiceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
        }

        @Override
        public final Builder serviceAccount(String serviceAccount) {
            this.serviceAccount = serviceAccount;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPodIdentityAssociationsRequest build() {
            return new ListPodIdentityAssociationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
