/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.eks.model.CreateAccessConfigRequest;
import software.amazon.awssdk.services.eks.model.EksRequest;
import software.amazon.awssdk.services.eks.model.EncryptionConfig;
import software.amazon.awssdk.services.eks.model.EncryptionConfigListCopier;
import software.amazon.awssdk.services.eks.model.KubernetesNetworkConfigRequest;
import software.amazon.awssdk.services.eks.model.Logging;
import software.amazon.awssdk.services.eks.model.OutpostConfigRequest;
import software.amazon.awssdk.services.eks.model.TagMapCopier;
import software.amazon.awssdk.services.eks.model.VpcConfigRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterRequest
extends EksRequest
implements ToCopyableBuilder<Builder, CreateClusterRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateClusterRequest.getter(CreateClusterRequest::name)).setter(CreateClusterRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(CreateClusterRequest.getter(CreateClusterRequest::version)).setter(CreateClusterRequest.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateClusterRequest.getter(CreateClusterRequest::roleArn)).setter(CreateClusterRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<VpcConfigRequest> RESOURCES_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesVpcConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::resourcesVpcConfig)).setter(CreateClusterRequest.setter(Builder::resourcesVpcConfig)).constructor(VpcConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesVpcConfig").build()}).build();
    private static final SdkField<KubernetesNetworkConfigRequest> KUBERNETES_NETWORK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kubernetesNetworkConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::kubernetesNetworkConfig)).setter(CreateClusterRequest.setter(Builder::kubernetesNetworkConfig)).constructor(KubernetesNetworkConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesNetworkConfig").build()}).build();
    private static final SdkField<Logging> LOGGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logging").getter(CreateClusterRequest.getter(CreateClusterRequest::logging)).setter(CreateClusterRequest.setter(Builder::logging)).constructor(Logging::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logging").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateClusterRequest.getter(CreateClusterRequest::clientRequestToken)).setter(CreateClusterRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateClusterRequest.getter(CreateClusterRequest::tags)).setter(CreateClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<EncryptionConfig>> ENCRYPTION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("encryptionConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::encryptionConfig)).setter(CreateClusterRequest.setter(Builder::encryptionConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EncryptionConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutpostConfigRequest> OUTPOST_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outpostConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::outpostConfig)).setter(CreateClusterRequest.setter(Builder::outpostConfig)).constructor(OutpostConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outpostConfig").build()}).build();
    private static final SdkField<CreateAccessConfigRequest> ACCESS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessConfig").getter(CreateClusterRequest.getter(CreateClusterRequest::accessConfig)).setter(CreateClusterRequest.setter(Builder::accessConfig)).constructor(CreateAccessConfigRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD, ROLE_ARN_FIELD, RESOURCES_VPC_CONFIG_FIELD, KUBERNETES_NETWORK_CONFIG_FIELD, LOGGING_FIELD, CLIENT_REQUEST_TOKEN_FIELD, TAGS_FIELD, ENCRYPTION_CONFIG_FIELD, OUTPOST_CONFIG_FIELD, ACCESS_CONFIG_FIELD));
    private final String name;
    private final String version;
    private final String roleArn;
    private final VpcConfigRequest resourcesVpcConfig;
    private final KubernetesNetworkConfigRequest kubernetesNetworkConfig;
    private final Logging logging;
    private final String clientRequestToken;
    private final Map<String, String> tags;
    private final List<EncryptionConfig> encryptionConfig;
    private final OutpostConfigRequest outpostConfig;
    private final CreateAccessConfigRequest accessConfig;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.version = builder.version;
        this.roleArn = builder.roleArn;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.kubernetesNetworkConfig = builder.kubernetesNetworkConfig;
        this.logging = builder.logging;
        this.clientRequestToken = builder.clientRequestToken;
        this.tags = builder.tags;
        this.encryptionConfig = builder.encryptionConfig;
        this.outpostConfig = builder.outpostConfig;
        this.accessConfig = builder.accessConfig;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final VpcConfigRequest resourcesVpcConfig() {
        return this.resourcesVpcConfig;
    }

    public final KubernetesNetworkConfigRequest kubernetesNetworkConfig() {
        return this.kubernetesNetworkConfig;
    }

    public final Logging logging() {
        return this.logging;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasEncryptionConfig() {
        return this.encryptionConfig != null && !(this.encryptionConfig instanceof SdkAutoConstructList);
    }

    public final List<EncryptionConfig> encryptionConfig() {
        return this.encryptionConfig;
    }

    public final OutpostConfigRequest outpostConfig() {
        return this.outpostConfig;
    }

    public final CreateAccessConfigRequest accessConfig() {
        return this.accessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesNetworkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logging());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncryptionConfig() ? this.encryptionConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.resourcesVpcConfig(), other.resourcesVpcConfig()) && Objects.equals(this.kubernetesNetworkConfig(), other.kubernetesNetworkConfig()) && Objects.equals(this.logging(), other.logging()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasEncryptionConfig() == other.hasEncryptionConfig() && Objects.equals(this.encryptionConfig(), other.encryptionConfig()) && Objects.equals(this.outpostConfig(), other.outpostConfig()) && Objects.equals(this.accessConfig(), other.accessConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterRequest").add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("RoleArn", (Object)this.roleArn()).add("ResourcesVpcConfig", (Object)this.resourcesVpcConfig()).add("KubernetesNetworkConfig", (Object)this.kubernetesNetworkConfig()).add("Logging", (Object)this.logging()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("Tags", this.hasTags() ? this.tags() : null).add("EncryptionConfig", this.hasEncryptionConfig() ? this.encryptionConfig() : null).add("OutpostConfig", (Object)this.outpostConfig()).add("AccessConfig", (Object)this.accessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "resourcesVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.resourcesVpcConfig()));
            }
            case "kubernetesNetworkConfig": {
                return Optional.ofNullable(clazz.cast(this.kubernetesNetworkConfig()));
            }
            case "logging": {
                return Optional.ofNullable(clazz.cast(this.logging()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "encryptionConfig": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfig()));
            }
            case "outpostConfig": {
                return Optional.ofNullable(clazz.cast(this.outpostConfig()));
            }
            case "accessConfig": {
                return Optional.ofNullable(clazz.cast(this.accessConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EksRequest.BuilderImpl
    implements Builder {
        private String name;
        private String version;
        private String roleArn;
        private VpcConfigRequest resourcesVpcConfig;
        private KubernetesNetworkConfigRequest kubernetesNetworkConfig;
        private Logging logging;
        private String clientRequestToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<EncryptionConfig> encryptionConfig = DefaultSdkAutoConstructList.getInstance();
        private OutpostConfigRequest outpostConfig;
        private CreateAccessConfigRequest accessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            this.name(model.name);
            this.version(model.version);
            this.roleArn(model.roleArn);
            this.resourcesVpcConfig(model.resourcesVpcConfig);
            this.kubernetesNetworkConfig(model.kubernetesNetworkConfig);
            this.logging(model.logging);
            this.clientRequestToken(model.clientRequestToken);
            this.tags(model.tags);
            this.encryptionConfig(model.encryptionConfig);
            this.outpostConfig(model.outpostConfig);
            this.accessConfig(model.accessConfig);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final VpcConfigRequest.Builder getResourcesVpcConfig() {
            return this.resourcesVpcConfig != null ? this.resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(VpcConfigRequest.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final KubernetesNetworkConfigRequest.Builder getKubernetesNetworkConfig() {
            return this.kubernetesNetworkConfig != null ? this.kubernetesNetworkConfig.toBuilder() : null;
        }

        public final void setKubernetesNetworkConfig(KubernetesNetworkConfigRequest.BuilderImpl kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig != null ? kubernetesNetworkConfig.build() : null;
        }

        @Override
        public final Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig) {
            this.kubernetesNetworkConfig = kubernetesNetworkConfig;
            return this;
        }

        public final Logging.Builder getLogging() {
            return this.logging != null ? this.logging.toBuilder() : null;
        }

        public final void setLogging(Logging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<EncryptionConfig.Builder> getEncryptionConfig() {
            List<EncryptionConfig.Builder> result = EncryptionConfigListCopier.copyToBuilder(this.encryptionConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEncryptionConfig(Collection<EncryptionConfig.BuilderImpl> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copyFromBuilder(encryptionConfig);
        }

        @Override
        public final Builder encryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
            this.encryptionConfig = EncryptionConfigListCopier.copy(encryptionConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(EncryptionConfig ... encryptionConfig) {
            this.encryptionConfig(Arrays.asList(encryptionConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encryptionConfig(Consumer<EncryptionConfig.Builder> ... encryptionConfig) {
            this.encryptionConfig(Stream.of(encryptionConfig).map(c -> (EncryptionConfig)((EncryptionConfig.Builder)EncryptionConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OutpostConfigRequest.Builder getOutpostConfig() {
            return this.outpostConfig != null ? this.outpostConfig.toBuilder() : null;
        }

        public final void setOutpostConfig(OutpostConfigRequest.BuilderImpl outpostConfig) {
            this.outpostConfig = outpostConfig != null ? outpostConfig.build() : null;
        }

        @Override
        public final Builder outpostConfig(OutpostConfigRequest outpostConfig) {
            this.outpostConfig = outpostConfig;
            return this;
        }

        public final CreateAccessConfigRequest.Builder getAccessConfig() {
            return this.accessConfig != null ? this.accessConfig.toBuilder() : null;
        }

        public final void setAccessConfig(CreateAccessConfigRequest.BuilderImpl accessConfig) {
            this.accessConfig = accessConfig != null ? accessConfig.build() : null;
        }

        @Override
        public final Builder accessConfig(CreateAccessConfigRequest accessConfig) {
            this.accessConfig = accessConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterRequest> {
        public Builder name(String var1);

        public Builder version(String var1);

        public Builder roleArn(String var1);

        public Builder resourcesVpcConfig(VpcConfigRequest var1);

        default public Builder resourcesVpcConfig(Consumer<VpcConfigRequest.Builder> resourcesVpcConfig) {
            return this.resourcesVpcConfig((VpcConfigRequest)((VpcConfigRequest.Builder)VpcConfigRequest.builder().applyMutation(resourcesVpcConfig)).build());
        }

        public Builder kubernetesNetworkConfig(KubernetesNetworkConfigRequest var1);

        default public Builder kubernetesNetworkConfig(Consumer<KubernetesNetworkConfigRequest.Builder> kubernetesNetworkConfig) {
            return this.kubernetesNetworkConfig((KubernetesNetworkConfigRequest)((KubernetesNetworkConfigRequest.Builder)KubernetesNetworkConfigRequest.builder().applyMutation(kubernetesNetworkConfig)).build());
        }

        public Builder logging(Logging var1);

        default public Builder logging(Consumer<Logging.Builder> logging) {
            return this.logging((Logging)((Logging.Builder)Logging.builder().applyMutation(logging)).build());
        }

        public Builder clientRequestToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder encryptionConfig(Collection<EncryptionConfig> var1);

        public Builder encryptionConfig(EncryptionConfig ... var1);

        public Builder encryptionConfig(Consumer<EncryptionConfig.Builder> ... var1);

        public Builder outpostConfig(OutpostConfigRequest var1);

        default public Builder outpostConfig(Consumer<OutpostConfigRequest.Builder> outpostConfig) {
            return this.outpostConfig((OutpostConfigRequest)((OutpostConfigRequest.Builder)OutpostConfigRequest.builder().applyMutation(outpostConfig)).build());
        }

        public Builder accessConfig(CreateAccessConfigRequest var1);

        default public Builder accessConfig(Consumer<CreateAccessConfigRequest.Builder> accessConfig) {
            return this.accessConfig((CreateAccessConfigRequest)((CreateAccessConfigRequest.Builder)CreateAccessConfigRequest.builder().applyMutation(accessConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

