/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CapacityTypes {
    ON_DEMAND("ON_DEMAND"),
    SPOT("SPOT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CapacityTypes> VALUE_MAP;
    private final String value;

    private CapacityTypes(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CapacityTypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CapacityTypes> knownValues() {
        EnumSet<CapacityTypes> knownValues = EnumSet.allOf(CapacityTypes.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CapacityTypes.class, CapacityTypes::toString);
    }
}

