/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object representing a Kubernetes label change for a managed node group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLabelsPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateLabelsPayload.Builder, UpdateLabelsPayload> {
    private static final SdkField<Map<String, String>> ADD_OR_UPDATE_LABELS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("addOrUpdateLabels")
            .getter(getter(UpdateLabelsPayload::addOrUpdateLabels))
            .setter(setter(Builder::addOrUpdateLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addOrUpdateLabels").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("removeLabels")
            .getter(getter(UpdateLabelsPayload::removeLabels))
            .setter(setter(Builder::removeLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADD_OR_UPDATE_LABELS_FIELD,
            REMOVE_LABELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> addOrUpdateLabels;

    private final List<String> removeLabels;

    private UpdateLabelsPayload(BuilderImpl builder) {
        this.addOrUpdateLabels = builder.addOrUpdateLabels;
        this.removeLabels = builder.removeLabels;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddOrUpdateLabels property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddOrUpdateLabels() {
        return addOrUpdateLabels != null && !(addOrUpdateLabels instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Kubernetes labels to be added or updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddOrUpdateLabels} method.
     * </p>
     * 
     * @return Kubernetes labels to be added or updated.
     */
    public final Map<String, String> addOrUpdateLabels() {
        return addOrUpdateLabels;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveLabels() {
        return removeLabels != null && !(removeLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Kubernetes labels to be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveLabels} method.
     * </p>
     * 
     * @return Kubernetes labels to be removed.
     */
    public final List<String> removeLabels() {
        return removeLabels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAddOrUpdateLabels() ? addOrUpdateLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveLabels() ? removeLabels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLabelsPayload)) {
            return false;
        }
        UpdateLabelsPayload other = (UpdateLabelsPayload) obj;
        return hasAddOrUpdateLabels() == other.hasAddOrUpdateLabels()
                && Objects.equals(addOrUpdateLabels(), other.addOrUpdateLabels()) && hasRemoveLabels() == other.hasRemoveLabels()
                && Objects.equals(removeLabels(), other.removeLabels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLabelsPayload")
                .add("AddOrUpdateLabels", hasAddOrUpdateLabels() ? addOrUpdateLabels() : null)
                .add("RemoveLabels", hasRemoveLabels() ? removeLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "addOrUpdateLabels":
            return Optional.ofNullable(clazz.cast(addOrUpdateLabels()));
        case "removeLabels":
            return Optional.ofNullable(clazz.cast(removeLabels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLabelsPayload, T> g) {
        return obj -> g.apply((UpdateLabelsPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateLabelsPayload> {
        /**
         * <p>
         * Kubernetes labels to be added or updated.
         * </p>
         * 
         * @param addOrUpdateLabels
         *        Kubernetes labels to be added or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addOrUpdateLabels(Map<String, String> addOrUpdateLabels);

        /**
         * <p>
         * Kubernetes labels to be removed.
         * </p>
         * 
         * @param removeLabels
         *        Kubernetes labels to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeLabels(Collection<String> removeLabels);

        /**
         * <p>
         * Kubernetes labels to be removed.
         * </p>
         * 
         * @param removeLabels
         *        Kubernetes labels to be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeLabels(String... removeLabels);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> addOrUpdateLabels = DefaultSdkAutoConstructMap.getInstance();

        private List<String> removeLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLabelsPayload model) {
            addOrUpdateLabels(model.addOrUpdateLabels);
            removeLabels(model.removeLabels);
        }

        public final Map<String, String> getAddOrUpdateLabels() {
            if (addOrUpdateLabels instanceof SdkAutoConstructMap) {
                return null;
            }
            return addOrUpdateLabels;
        }

        public final void setAddOrUpdateLabels(Map<String, String> addOrUpdateLabels) {
            this.addOrUpdateLabels = _labelsMapCopier.copy(addOrUpdateLabels);
        }

        @Override
        public final Builder addOrUpdateLabels(Map<String, String> addOrUpdateLabels) {
            this.addOrUpdateLabels = _labelsMapCopier.copy(addOrUpdateLabels);
            return this;
        }

        public final Collection<String> getRemoveLabels() {
            if (removeLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return removeLabels;
        }

        public final void setRemoveLabels(Collection<String> removeLabels) {
            this.removeLabels = _labelsKeyListCopier.copy(removeLabels);
        }

        @Override
        public final Builder removeLabels(Collection<String> removeLabels) {
            this.removeLabels = _labelsKeyListCopier.copy(removeLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeLabels(String... removeLabels) {
            removeLabels(Arrays.asList(removeLabels));
            return this;
        }

        @Override
        public UpdateLabelsPayload build() {
            return new UpdateLabelsPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
