/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.eks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUpdatesResponse extends EksResponse implements
        ToCopyableBuilder<ListUpdatesResponse.Builder, ListUpdatesResponse> {
    private static final SdkField<List<String>> UPDATE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("updateIds")
            .getter(getter(ListUpdatesResponse::updateIds))
            .setter(setter(Builder::updateIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUpdatesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_IDS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> updateIds;

    private final String nextToken;

    private ListUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.updateIds = builder.updateIds;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UpdateIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUpdateIds() {
        return updateIds != null && !(updateIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of all the updates for the specified cluster and Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUpdateIds} method.
     * </p>
     * 
     * @return A list of all the updates for the specified cluster and Region.
     */
    public final List<String> updateIds() {
        return updateIds;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the results of a
     * <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to retrieve the next page
     * of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the
     *         results of a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to
     *         retrieve the next page of results. This value is <code>null</code> when there are no more results to
     *         return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUpdateIds() ? updateIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUpdatesResponse)) {
            return false;
        }
        ListUpdatesResponse other = (ListUpdatesResponse) obj;
        return hasUpdateIds() == other.hasUpdateIds() && Objects.equals(updateIds(), other.updateIds())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUpdatesResponse").add("UpdateIds", hasUpdateIds() ? updateIds() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "updateIds":
            return Optional.ofNullable(clazz.cast(updateIds()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUpdatesResponse, T> g) {
        return obj -> g.apply((ListUpdatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EksResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUpdatesResponse> {
        /**
         * <p>
         * A list of all the updates for the specified cluster and Region.
         * </p>
         * 
         * @param updateIds
         *        A list of all the updates for the specified cluster and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIds(Collection<String> updateIds);

        /**
         * <p>
         * A list of all the updates for the specified cluster and Region.
         * </p>
         * 
         * @param updateIds
         *        A list of all the updates for the specified cluster and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIds(String... updateIds);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the results of
         * a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value to retrieve the
         * next page of results. This value is <code>null</code> when there are no more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListUpdates</code> request. When the
         *        results of a <code>ListUpdates</code> request exceed <code>maxResults</code>, you can use this value
         *        to retrieve the next page of results. This value is <code>null</code> when there are no more results
         *        to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EksResponse.BuilderImpl implements Builder {
        private List<String> updateIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUpdatesResponse model) {
            super(model);
            updateIds(model.updateIds);
            nextToken(model.nextToken);
        }

        public final Collection<String> getUpdateIds() {
            if (updateIds instanceof SdkAutoConstructList) {
                return null;
            }
            return updateIds;
        }

        public final void setUpdateIds(Collection<String> updateIds) {
            this.updateIds = StringListCopier.copy(updateIds);
        }

        @Override
        public final Builder updateIds(Collection<String> updateIds) {
            this.updateIds = StringListCopier.copy(updateIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateIds(String... updateIds) {
            updateIds(Arrays.asList(updateIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListUpdatesResponse build() {
            return new ListUpdatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
