/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.efs.EfsClient;
import software.amazon.awssdk.services.efs.internal.UserAgentUtils;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsRequest;
import software.amazon.awssdk.services.efs.model.DescribeMountTargetsResponse;
import software.amazon.awssdk.services.efs.model.MountTargetDescription;

public class DescribeMountTargetsIterable
implements SdkIterable<DescribeMountTargetsResponse> {
    private final EfsClient client;
    private final DescribeMountTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMountTargetsIterable(EfsClient client, DescribeMountTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMountTargetsResponseFetcher();
    }

    public Iterator<DescribeMountTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MountTargetDescription> mountTargets() {
        Function<DescribeMountTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.mountTargets() != null) {
                return response.mountTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMountTargetsResponseFetcher
    implements SyncPageFetcher<DescribeMountTargetsResponse> {
        private DescribeMountTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMountTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeMountTargetsResponse nextPage(DescribeMountTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeMountTargetsIterable.this.client.describeMountTargets(DescribeMountTargetsIterable.this.firstRequest);
            }
            return DescribeMountTargetsIterable.this.client.describeMountTargets((DescribeMountTargetsRequest)((Object)DescribeMountTargetsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

