/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.efs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransitionToArchiveRules {
    AFTER_1_DAY("AFTER_1_DAY"),
    AFTER_7_DAYS("AFTER_7_DAYS"),
    AFTER_14_DAYS("AFTER_14_DAYS"),
    AFTER_30_DAYS("AFTER_30_DAYS"),
    AFTER_60_DAYS("AFTER_60_DAYS"),
    AFTER_90_DAYS("AFTER_90_DAYS"),
    AFTER_180_DAYS("AFTER_180_DAYS"),
    AFTER_270_DAYS("AFTER_270_DAYS"),
    AFTER_365_DAYS("AFTER_365_DAYS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransitionToArchiveRules> VALUE_MAP;
    private final String value;

    private TransitionToArchiveRules(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransitionToArchiveRules fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransitionToArchiveRules> knownValues() {
        EnumSet<TransitionToArchiveRules> knownValues = EnumSet.allOf(TransitionToArchiveRules.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransitionToArchiveRules.class, TransitionToArchiveRules::toString);
    }
}

