/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanaryConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanaryConfiguration> {
    private static final SdkField<Double> CANARY_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("canaryPercent").getter(CanaryConfiguration.getter(CanaryConfiguration::canaryPercent)).setter(CanaryConfiguration.setter(Builder::canaryPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canaryPercent").build()}).build();
    private static final SdkField<Integer> CANARY_BAKE_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("canaryBakeTimeInMinutes").getter(CanaryConfiguration.getter(CanaryConfiguration::canaryBakeTimeInMinutes)).setter(CanaryConfiguration.setter(Builder::canaryBakeTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canaryBakeTimeInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANARY_PERCENT_FIELD, CANARY_BAKE_TIME_IN_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CanaryConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Double canaryPercent;
    private final Integer canaryBakeTimeInMinutes;

    private CanaryConfiguration(BuilderImpl builder) {
        this.canaryPercent = builder.canaryPercent;
        this.canaryBakeTimeInMinutes = builder.canaryBakeTimeInMinutes;
    }

    public final Double canaryPercent() {
        return this.canaryPercent;
    }

    public final Integer canaryBakeTimeInMinutes() {
        return this.canaryBakeTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.canaryPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.canaryBakeTimeInMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanaryConfiguration)) {
            return false;
        }
        CanaryConfiguration other = (CanaryConfiguration)obj;
        return Objects.equals(this.canaryPercent(), other.canaryPercent()) && Objects.equals(this.canaryBakeTimeInMinutes(), other.canaryBakeTimeInMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"CanaryConfiguration").add("CanaryPercent", (Object)this.canaryPercent()).add("CanaryBakeTimeInMinutes", (Object)this.canaryBakeTimeInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "canaryPercent": {
                return Optional.ofNullable(clazz.cast(this.canaryPercent()));
            }
            case "canaryBakeTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.canaryBakeTimeInMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("canaryPercent", CANARY_PERCENT_FIELD);
        map.put("canaryBakeTimeInMinutes", CANARY_BAKE_TIME_IN_MINUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanaryConfiguration, T> g) {
        return obj -> g.apply((CanaryConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double canaryPercent;
        private Integer canaryBakeTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(CanaryConfiguration model) {
            this.canaryPercent(model.canaryPercent);
            this.canaryBakeTimeInMinutes(model.canaryBakeTimeInMinutes);
        }

        public final Double getCanaryPercent() {
            return this.canaryPercent;
        }

        public final void setCanaryPercent(Double canaryPercent) {
            this.canaryPercent = canaryPercent;
        }

        @Override
        public final Builder canaryPercent(Double canaryPercent) {
            this.canaryPercent = canaryPercent;
            return this;
        }

        public final Integer getCanaryBakeTimeInMinutes() {
            return this.canaryBakeTimeInMinutes;
        }

        public final void setCanaryBakeTimeInMinutes(Integer canaryBakeTimeInMinutes) {
            this.canaryBakeTimeInMinutes = canaryBakeTimeInMinutes;
        }

        @Override
        public final Builder canaryBakeTimeInMinutes(Integer canaryBakeTimeInMinutes) {
            this.canaryBakeTimeInMinutes = canaryBakeTimeInMinutes;
            return this;
        }

        public CanaryConfiguration build() {
            return new CanaryConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanaryConfiguration> {
        public Builder canaryPercent(Double var1);

        public Builder canaryBakeTimeInMinutes(Integer var1);
    }
}

