/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.Failure;
import software.amazon.awssdk.services.ecs.model.FailuresCopier;
import software.amazon.awssdk.services.ecs.model.TaskDefinition;
import software.amazon.awssdk.services.ecs.model.TaskDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteTaskDefinitionsResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, DeleteTaskDefinitionsResponse> {
    private static final SdkField<List<TaskDefinition>> TASK_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("taskDefinitions").getter(DeleteTaskDefinitionsResponse.getter(DeleteTaskDefinitionsResponse::taskDefinitions)).setter(DeleteTaskDefinitionsResponse.setter(Builder::taskDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Failure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(DeleteTaskDefinitionsResponse.getter(DeleteTaskDefinitionsResponse::failures)).setter(DeleteTaskDefinitionsResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Failure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITIONS_FIELD, FAILURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteTaskDefinitionsResponse.memberNameToFieldInitializer();
    private final List<TaskDefinition> taskDefinitions;
    private final List<Failure> failures;

    private DeleteTaskDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.taskDefinitions = builder.taskDefinitions;
        this.failures = builder.failures;
    }

    public final boolean hasTaskDefinitions() {
        return this.taskDefinitions != null && !(this.taskDefinitions instanceof SdkAutoConstructList);
    }

    public final List<TaskDefinition> taskDefinitions() {
        return this.taskDefinitions;
    }

    public final boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public final List<Failure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskDefinitions() ? this.taskDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailures() ? this.failures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTaskDefinitionsResponse)) {
            return false;
        }
        DeleteTaskDefinitionsResponse other = (DeleteTaskDefinitionsResponse)((Object)obj);
        return this.hasTaskDefinitions() == other.hasTaskDefinitions() && Objects.equals(this.taskDefinitions(), other.taskDefinitions()) && this.hasFailures() == other.hasFailures() && Objects.equals(this.failures(), other.failures());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteTaskDefinitionsResponse").add("TaskDefinitions", this.hasTaskDefinitions() ? this.taskDefinitions() : null).add("Failures", this.hasFailures() ? this.failures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskDefinitions": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitions()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taskDefinitions", TASK_DEFINITIONS_FIELD);
        map.put("failures", FAILURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteTaskDefinitionsResponse, T> g) {
        return obj -> g.apply((DeleteTaskDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<TaskDefinition> taskDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<Failure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteTaskDefinitionsResponse model) {
            super(model);
            this.taskDefinitions(model.taskDefinitions);
            this.failures(model.failures);
        }

        public final List<TaskDefinition.Builder> getTaskDefinitions() {
            List<TaskDefinition.Builder> result = TaskDefinitionListCopier.copyToBuilder(this.taskDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskDefinitions(Collection<TaskDefinition.BuilderImpl> taskDefinitions) {
            this.taskDefinitions = TaskDefinitionListCopier.copyFromBuilder(taskDefinitions);
        }

        @Override
        public final Builder taskDefinitions(Collection<TaskDefinition> taskDefinitions) {
            this.taskDefinitions = TaskDefinitionListCopier.copy(taskDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskDefinitions(TaskDefinition ... taskDefinitions) {
            this.taskDefinitions(Arrays.asList(taskDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskDefinitions(Consumer<TaskDefinition.Builder> ... taskDefinitions) {
            this.taskDefinitions(Stream.of(taskDefinitions).map(c -> (TaskDefinition)((TaskDefinition.Builder)TaskDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Failure.Builder> getFailures() {
            List<Failure.Builder> result = FailuresCopier.copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<Failure.BuilderImpl> failures) {
            this.failures = FailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<Failure> failures) {
            this.failures = FailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Failure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<Failure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (Failure)((Failure.Builder)Failure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteTaskDefinitionsResponse build() {
            return new DeleteTaskDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteTaskDefinitionsResponse> {
        public Builder taskDefinitions(Collection<TaskDefinition> var1);

        public Builder taskDefinitions(TaskDefinition ... var1);

        public Builder taskDefinitions(Consumer<TaskDefinition.Builder> ... var1);

        public Builder failures(Collection<Failure> var1);

        public Builder failures(Failure ... var1);

        public Builder failures(Consumer<Failure.Builder> ... var1);
    }
}

