/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StabilityStatus {
    STEADY_STATE("STEADY_STATE"),
    STABILIZING("STABILIZING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StabilityStatus> VALUE_MAP;
    private final String value;

    private StabilityStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StabilityStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StabilityStatus> knownValues() {
        EnumSet<StabilityStatus> knownValues = EnumSet.allOf(StabilityStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StabilityStatus.class, StabilityStatus::toString);
    }
}

